<?php
require __DIR__ . '/bootstrap.php';
require dirname(__DIR__) . '/includes/class-wpst-pricing-sync.php';

$GLOBALS['wpdb']->rows = [
    [
        'id' => 5,
        'item_slug' => 'elementor-pro',
        'item_name' => 'Elementor Pro',
        'billing_cycle' => 'annually',
        'cost' => 49.0,
        'market_price' => 49.0,
        'status' => 'active',
    ],
];

update_option('wpst_pricing_api_base', 'https://api.web321.co/v1/pricing');
update_option('wpst_pricing_api_key', 'abc123');

$GLOBALS['__remote_post']['https://api.web321.co/v1/pricing/batch'] = [
    'response' => ['code' => 200],
    'body' => json_encode([
        'data' => [
            [
                'slug' => 'elementor-pro',
                'url' => 'https://example.com/elementor-pro',
                'pricing' => ['annual' => 59.00, 'currency' => 'USD'],
            ],
        ],
    ]),
];

$sync = new WPST_Pricing_Sync();
$sync->sync_all_pricing();

if (count($GLOBALS['wpdb']->updates) === 0) {
    fwrite(STDERR, "Expected subscription table update\n");
    exit(1);
}

$update = $GLOBALS['wpdb']->updates[0]['data'];
if ((float) ($update['cost'] ?? 0) !== 59.0 || (float) ($update['market_price'] ?? 0) !== 59.0) {
    fwrite(STDERR, "Expected cost/market_price updates to 59.00\n");
    exit(1);
}

if (count($GLOBALS['wpdb']->inserts) === 0) {
    fwrite(STDERR, "Expected price change log insert\n");
    exit(1);
}

$insert = $GLOBALS['wpdb']->inserts[0];
if (strpos((string) $insert['table'], 'subscription_price_changes') === false) {
    fwrite(STDERR, "Price changes were not stored in expected table\n");
    exit(1);
}

if (empty($GLOBALS['__remote_post_calls'])) {
    fwrite(STDERR, "Expected API request to be executed\n");
    exit(1);
}


// Retry path should backoff and eventually succeed on transient failures.
$GLOBALS['wpdb']->rows = [
    [
        'id' => 8,
        'item_slug' => 'gravity-forms',
        'item_name' => 'Gravity Forms',
        'billing_cycle' => 'annually',
        'cost' => 79.0,
        'market_price' => 79.0,
        'status' => 'active',
    ],
];
$GLOBALS['wpdb']->updates = [];
$GLOBALS['wpdb']->inserts = [];
$GLOBALS['__remote_post_calls'] = [];
update_option('wpst_site_token', 'site-token-xyz');
delete_transient('wpst_pricing_last_request_ts');

$GLOBALS['__remote_post']['https://api.web321.co/v1/pricing/batch'] = [
    '__queue' => [
        new RuntimeException('temporary_network_error'),
        ['response' => ['code' => 429], 'body' => json_encode(['error' => 'rate_limited'])],
        [
            'response' => ['code' => 200],
            'body' => json_encode([
                'data' => [
                    [
                        'slug' => 'gravity-forms',
                        'url' => 'https://example.com/gravity-forms',
                        'pricing' => ['annual' => 99.00, 'currency' => 'USD'],
                    ],
                ],
            ]),
        ],
    ],
];

$retrySync = new WPST_Pricing_Sync();
$reflection = new ReflectionClass($retrySync);
$backoffProp = $reflection->getProperty('retry_backoff_ms');
$backoffProp->setAccessible(true);
$backoffProp->setValue($retrySync, 1);
$retrySync->sync_all_pricing();

if (count($GLOBALS['__remote_post_calls']) !== 3) {
    fwrite(STDERR, "Expected 3 API calls for retry flow\n");
    exit(1);
}

$latestCall = end($GLOBALS['__remote_post_calls']);
$payload = json_decode((string) ($latestCall['args']['body'] ?? ''), true);
if (! is_array($payload) || ($payload['site_token'] ?? '') !== 'site-token-xyz') {
    fwrite(STDERR, "Expected site token in pricing sync payload\n");
    exit(1);
}

if (empty(get_transient('wpst_pricing_last_request_ts'))) {
    fwrite(STDERR, "Expected pricing sync rate-limit transient to be set\n");
    exit(1);
}

echo "pricing sync tests passed\n";

// Failover: unavailable API should not update records.
$GLOBALS['wpdb']->rows = [
    [
        'id' => 11,
        'item_slug' => 'bricks-builder',
        'item_name' => 'Bricks Builder',
        'billing_cycle' => 'annually',
        'cost' => 99.0,
        'market_price' => 99.0,
        'status' => 'active',
    ],
];
$GLOBALS['wpdb']->updates = [];
$GLOBALS['wpdb']->inserts = [];
$GLOBALS['__remote_post_calls'] = [];
delete_transient('wpst_pricing_last_request_ts');

$GLOBALS['__remote_post']['https://api.web321.co/v1/pricing/batch'] = [
    '__queue' => [
        new RuntimeException('network_down_1'),
        new RuntimeException('network_down_2'),
        new RuntimeException('network_down_3'),
    ],
];

$offlineSync = new WPST_Pricing_Sync();
$offlineReflection = new ReflectionClass($offlineSync);
$offlineBackoff = $offlineReflection->getProperty('retry_backoff_ms');
$offlineBackoff->setAccessible(true);
$offlineBackoff->setValue($offlineSync, 1);
$offlineSync->sync_all_pricing();

if (count($GLOBALS['__remote_post_calls']) !== 3) {
    fwrite(STDERR, "Expected 3 retry attempts when pricing API is unavailable\n");
    exit(1);
}

if (count($GLOBALS['wpdb']->updates) !== 0) {
    fwrite(STDERR, "Expected no record updates when pricing API is unavailable\n");
    exit(1);
}

// Failover: malformed payload should not update records.
$GLOBALS['wpdb']->updates = [];
$GLOBALS['wpdb']->inserts = [];
$GLOBALS['__remote_post_calls'] = [];
delete_transient('wpst_pricing_last_request_ts');

$GLOBALS['__remote_post']['https://api.web321.co/v1/pricing/batch'] = [
    'response' => ['code' => 200],
    'body' => '{"data":"bad-shape"}',
];

$malformedSync = new WPST_Pricing_Sync();
$malformedSync->sync_all_pricing();

if (count($GLOBALS['wpdb']->updates) !== 0) {
    fwrite(STDERR, "Expected no updates for malformed pricing payload\n");
    exit(1);
}

// Failover: payload missing relevant product records should not update records.
$GLOBALS['wpdb']->updates = [];
$GLOBALS['wpdb']->inserts = [];
$GLOBALS['__remote_post_calls'] = [];
delete_transient('wpst_pricing_last_request_ts');

$GLOBALS['__remote_post']['https://api.web321.co/v1/pricing/batch'] = [
    'response' => ['code' => 200],
    'body' => json_encode([
        'data' => [
            [
                'slug' => 'not-the-installed-plugin',
                'url' => 'https://example.com/other-plugin',
                'pricing' => ['annual' => 25.00],
            ],
        ],
    ]),
];

$missingRecordSync = new WPST_Pricing_Sync();
$missingRecordSync->sync_all_pricing();

if (count($GLOBALS['wpdb']->updates) !== 0) {
    fwrite(STDERR, "Expected no updates when pricing payload lacks matching plugin slugs\n");
    exit(1);
}

echo "pricing sync failover tests passed\n";
