<?php
require __DIR__ . '/bootstrap.php';
require dirname(__DIR__) . '/includes/class-wpst-activator.php';
require dirname(__DIR__) . '/includes/class-wpst-deactivator.php';

WPST_Activator::activate();

$sql = implode("\n", $GLOBALS['__dbdelta']);
if (strpos($sql, "item_type ENUM('plugin','theme','service','hosting','domain','other')") === false) {
    fwrite(STDERR, "Activation schema missing item types\n");
    exit(1);
}

if (strpos($sql, 'vendor_url VARCHAR(512) NULL') === false || strpos($sql, "handled_by ENUM('vendor','management_company')") === false) {
    fwrite(STDERR, "Activation schema missing vendor metadata columns\n");
    exit(1);
}

if (!isset($GLOBALS['__wp_options']['wpst_site_token'])) {
    fwrite(STDERR, "Site token option was not created\n");
    exit(1);
}

WPST_Deactivator::deactivate();
$expected = ['wpst_daily_check', 'wpst_daily_pricing_sync', 'wpst_weekly_aff_sync', 'wpst_monthly_history_snapshot'];
foreach ($expected as $hook) {
    if (!in_array($hook, $GLOBALS['__cleared_hooks'], true)) {
        fwrite(STDERR, "Expected hook not cleared: {$hook}\n");
        exit(1);
    }
}

$uninstall = file_get_contents(dirname(__DIR__) . '/uninstall.php');
if (strpos($uninstall, 'subscription_tracker_history') === false || strpos($uninstall, 'subscription_price_changes') === false || strpos($uninstall, "delete_option('wpst_site_token')") === false || strpos($uninstall, "delete_option('wpst_pricing_api_base')") === false) {
    fwrite(STDERR, "Uninstall cleanup missing pricing cleanup artifacts\n");
    exit(1);
}

echo "lifecycle tests passed\n";
