<?php
require __DIR__ . '/bootstrap.php';
require dirname(__DIR__) . '/includes/class-wpst-export.php';

$rows = [
    [
        'item_name' => "My, Plugin",
        'vendor' => 'Acme "Corp"',
        'cost' => '9.99',
        'currency' => 'USD',
        'billing_cycle' => 'monthly',
        'renewal_date' => '2026-04-01',
        'status' => "active\nsoon",
    ],
];

$fp = fopen('php://temp', 'w+');
WPST_Export::write_csv_rows($fp, $rows);
rewind($fp);
$csv = stream_get_contents($fp);
if (!is_string($csv) || $csv === '') {
    fwrite(STDERR, "CSV output missing\n");
    exit(1);
}

if (strpos($csv, '"My, Plugin"') === false || strpos($csv, '"Acme ""Corp"""') === false) {
    fwrite(STDERR, "CSV escaping missing for commas/quotes\n");
    exit(1);
}

echo "csv export tests passed\n";
