<?php
require __DIR__ . '/bootstrap.php';
require dirname(__DIR__) . '/includes/class-wpst-admin.php';

$admin = new WPST_Admin();

// Deny user capability.
$GLOBALS['__current_user_can'] = false;
$GLOBALS['__ajax_nonce_valid'] = true;
$_POST = ['nonce' => 'valid'];

try {
    $admin->ajax_list_subscriptions();
    fwrite(STDERR, "Expected capability check failure\n");
    exit(1);
} catch (RuntimeException $exception) {
    if (strpos($exception->getMessage(), 'json_error:403:') !== 0) {
        fwrite(STDERR, "Unexpected error for capability denial: {$exception->getMessage()}\n");
        exit(1);
    }
}

// Nonce invalid.
$GLOBALS['__current_user_can'] = true;
$GLOBALS['__ajax_nonce_valid'] = false;

try {
    $admin->ajax_list_subscriptions();
    fwrite(STDERR, "Expected nonce failure\n");
    exit(1);
} catch (RuntimeException $exception) {
    if ($exception->getMessage() !== 'invalid_ajax_nonce') {
        fwrite(STDERR, "Unexpected error for nonce denial: {$exception->getMessage()}\n");
        exit(1);
    }
}

// Authorized request returns JSON payload.
$GLOBALS['__current_user_can'] = true;
$GLOBALS['__ajax_nonce_valid'] = true;
$_POST = ['nonce' => 'valid', 'filter' => 'all', 'search' => '', 'sort' => 'renewal_asc'];
$GLOBALS['wpdb']->rows = [];

try {
    $admin->ajax_list_subscriptions();
    fwrite(STDERR, "Expected JSON success response\n");
    exit(1);
} catch (RuntimeException $exception) {
    if (strpos($exception->getMessage(), 'json_success:200:') !== 0) {
        fwrite(STDERR, "Unexpected success payload: {$exception->getMessage()}\n");
        exit(1);
    }
}

echo "ajax auth tests passed\n";
