<?php
require __DIR__ . '/bootstrap.php';
require dirname(__DIR__) . '/includes/class-wpst-affiliates.php';

$aff = new WPST_Affiliates();

$validXml = <<<XML
<links>
  <link><id>abc123</id><slug>plugin-pro</slug><url>https://example.com/a?b=1</url></link>
</links>
XML;

$parsed = $aff->parse_affiliate_xml($validXml);
if (!isset($parsed['plugin-pro']) || $parsed['plugin-pro']['id'] !== 'abc123') {
    fwrite(STDERR, "Failed to parse valid affiliate XML\n");
    exit(1);
}

$web321DemoXml = <<<XML
<affiliate_links>
  <product>
    <id>elementor-pro</id>
    <match_slugs>
      <slug>elementor-pro</slug>
      <slug>elementor</slug>
    </match_slugs>
    <signup_url>https://web321.co/go/elementor-signup</signup_url>
    <renew_url>https://web321.co/go/elementor-renew</renew_url>
    <url>https://web321.co/go/elementor-renew</url>
  </product>
  <product>
    <id>gravity-forms</id>
    <match_slugs>
      <slug>gravityforms</slug>
    </match_slugs>
    <signup_url>https://web321.co/go/gravity-forms-signup</signup_url>
    <url>https://web321.co/go/gravity-forms-signup</url>
  </product>
</affiliate_links>
XML;

$parsedWeb321 = $aff->parse_affiliate_xml($web321DemoXml);
if (!isset($parsedWeb321['elementor-pro']) || ($parsedWeb321['elementor-pro']['renew_url'] ?? '') !== 'https://web321.co/go/elementor-renew') {
    fwrite(STDERR, "Failed to parse Web321 renew URL\n");
    exit(1);
}

if (!isset($parsedWeb321['elementor']) || ($parsedWeb321['elementor']['signup_url'] ?? '') !== 'https://web321.co/go/elementor-signup') {
    fwrite(STDERR, "Failed to parse Web321 signup URL\n");
    exit(1);
}

if (!isset($parsedWeb321['gravityforms']) || ($parsedWeb321['gravityforms']['url'] ?? '') !== 'https://web321.co/go/gravity-forms-signup') {
    fwrite(STDERR, "Failed to parse fallback URL\n");
    exit(1);
}

$xxeXml = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE foo [ <!ENTITY xxe SYSTEM "file:///etc/passwd"> ]>
<links>
  <link><id>evil</id><slug>bad-plugin</slug><url>https://example.com/&xxe;</url></link>
</links>
XML;

$parsedXxe = $aff->parse_affiliate_xml($xxeXml);
if ($parsedXxe !== []) {
    fwrite(STDERR, "XXE payload should be blocked\n");
    exit(1);
}

echo "affiliate xml tests passed\n";
