<?php

define('ABSPATH', __DIR__ . '/');
define('ARRAY_A', 'ARRAY_A');
define('WEEK_IN_SECONDS', 604800);
define('DAY_IN_SECONDS', 86400);
define('HOUR_IN_SECONDS', 3600);
define('WPST_PLUGIN_DIR', dirname(__DIR__) . '/');

$GLOBALS['__wp_options'] = [];
$GLOBALS['__wp_transients'] = [];
$GLOBALS['__scheduled'] = [];
$GLOBALS['__cleared_hooks'] = [];
$GLOBALS['__dbdelta'] = [];
$GLOBALS['__current_user_can'] = true;
$GLOBALS['__ajax_nonce_valid'] = true;

$GLOBALS['__remote_post'] = [];
$GLOBALS['__remote_post_calls'] = [];
function wp_remote_post(string $url, array $args = []) {
    $GLOBALS['__remote_post_calls'][] = ['url' => $url, 'args' => $args];
    $mock = $GLOBALS['__remote_post'][$url] ?? new RuntimeException('missing_mock');

    if (is_callable($mock)) {
        return $mock($url, $args);
    }

    if (is_array($mock) && isset($mock['__queue']) && is_array($mock['__queue'])) {
        $next = array_shift($mock['__queue']);
        $GLOBALS['__remote_post'][$url] = $mock;

        return $next ?? new RuntimeException('missing_mock_queue_item');
    }

    return $mock;
}
function is_wp_error($thing): bool { return $thing instanceof RuntimeException; }
function wp_remote_retrieve_response_code($response): int { return is_array($response) ? (int) ($response['response']['code'] ?? 0) : 0; }
function wp_remote_retrieve_body($response): string { return is_array($response) ? (string) ($response['body'] ?? '') : ''; }
function wp_json_encode($data): string { return json_encode($data); }
function esc_url(string $url): string { return $url; }

function __(string $text, string $domain = ''): string { return $text; }
function sanitize_title(string $value): string { $value = strtolower(trim($value)); $value = preg_replace('/[^a-z0-9]+/i', '-', $value); return trim((string) $value, '-'); }
function esc_url_raw(string $url): string { return filter_var($url, FILTER_VALIDATE_URL) ? $url : ''; }
function sanitize_text_field(string $value): string { return trim(strip_tags($value)); }
function sanitize_textarea_field(string $value): string { return trim(strip_tags($value)); }
function get_option(string $key, $default = false) { return $GLOBALS['__wp_options'][$key] ?? $default; }
function add_option(string $key, $value): void { $GLOBALS['__wp_options'][$key] = $value; }
function update_option(string $key, $value, bool $autoload = true): void { $GLOBALS['__wp_options'][$key] = $value; }
function delete_option(string $key): void { unset($GLOBALS['__wp_options'][$key]); }
function set_transient(string $key, $value, int $expiration): void { $GLOBALS['__wp_transients'][$key] = $value; }
function get_transient(string $key) { return $GLOBALS['__wp_transients'][$key] ?? false; }
function delete_transient(string $key): void { unset($GLOBALS['__wp_transients'][$key]); }
function current_time(string $type) { return $type === 'mysql' ? '2026-01-01 00:00:00' : time(); }
function wp_generate_password(int $length = 12, bool $special_chars = true, bool $extra_special_chars = false): string { return str_repeat('a', $length); }
function wp_next_scheduled(string $hook) { return $GLOBALS['__scheduled'][$hook] ?? false; }
function wp_get_schedules(): array { return ['daily' => ['interval' => 86400], 'weekly' => ['interval' => 604800], 'monthly' => ['interval' => 2592000]]; }
function wp_schedule_event(int $timestamp, string $recurrence, string $hook): void { $GLOBALS['__scheduled'][$hook] = ['timestamp' => $timestamp, 'recurrence' => $recurrence]; }
function wp_clear_scheduled_hook(string $hook): void { $GLOBALS['__cleared_hooks'][] = $hook; }
function dbDelta(string $sql): void { $GLOBALS['__dbdelta'][] = $sql; }
function current_user_can(string $capability): bool { return (bool) ($GLOBALS['__current_user_can'] ?? false); }
function check_ajax_referer(string $action, $query_arg = false, bool $stop = true): bool {
    if (! ($GLOBALS['__ajax_nonce_valid'] ?? false)) {
        throw new RuntimeException('invalid_ajax_nonce');
    }

    return true;
}
function check_admin_referer(string $action = '-1', string $query_arg = '_wpnonce'): bool { return true; }
function wp_send_json_success($data = null, int $status_code = 200): void { throw new RuntimeException('json_success:' . $status_code . ':' . json_encode($data)); }
function wp_send_json_error($data = null, int $status_code = null): void {
    $status = $status_code ?? 200;
    throw new RuntimeException('json_error:' . $status . ':' . json_encode($data));
}
function wp_date(string $format, ?int $timestamp = null): string { return gmdate($format, $timestamp ?? time()); }

class TestWpdb {
    public $prefix = 'wp_';
    public $options = 'wp_options';
    /** @var array<int, array<string,mixed>> */
    public $rows = [];
    /** @var array<int,string> */
    public $queries = [];
    public $updates = [];
    public $inserts = [];

    public function get_results(string $query, $output = null): array { $this->queries[] = $query; return $this->rows; }
    public function esc_like(string $text): string { return addcslashes($text, '_%\\'); }
    public function prepare(string $query, ...$args): string { return vsprintf(str_replace(['%d', '%f', '%s'], ['%u', '%F', "'%s'"], $query), $args); }
    public function get_row(string $query, $output = null): ?array { $this->queries[] = $query; return $this->rows[0] ?? null; }
    public function get_var(string $query) { $this->queries[] = $query; return null; }
    public function insert(string $table, array $data): void { $this->rows[] = $data; $this->inserts[] = ['table' => $table, 'data' => $data]; }
    public function delete(string $table, array $where): void {}
    public function update(string $table, array $data, array $where, array $format = [], array $where_format = []): void { $this->updates[] = ['table' => $table, 'data' => $data, 'where' => $where]; }
    public function query(string $sql): void { $this->queries[] = $sql; }
    public function get_charset_collate(): string { return 'DEFAULT CHARSET=utf8mb4'; }
}

$GLOBALS['wpdb'] = new TestWpdb();
