<?php
/**
 * HTML email template for renewal reminders.
 *
 * Expects:
 * - $templateData['item_name']
 * - $templateData['vendor']
 * - $templateData['renewal_date']
 * - $templateData['days_until']
 * - $templateData['formatted_price']
 * - $templateData['affiliate_url']
 */

if (! defined('ABSPATH')) {
    exit;
}

$itemName       = esc_html((string) ($templateData['item_name'] ?? ''));
$vendor         = esc_html((string) ($templateData['vendor'] ?? ''));
$renewalDate    = esc_html((string) ($templateData['renewal_date'] ?? ''));
$daysUntil      = (int) ($templateData['days_until'] ?? 0);
$formattedPrice = esc_html((string) ($templateData['formatted_price'] ?? ''));
$affiliateUrl   = esc_url((string) ($templateData['affiliate_url'] ?? ''));
?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8" />
    <title><?php echo esc_html__('Subscription Renewal Reminder', 'wp-subscription-tracker'); ?></title>
</head>
<body style="font-family: Arial, sans-serif; color: #1f2937; line-height: 1.5;">
    <h2 style="margin:0 0 12px;"><?php echo esc_html__('Renewal Reminder', 'wp-subscription-tracker'); ?></h2>
    <p style="margin:0 0 12px;">
        <?php
        echo wp_kses_post(
            sprintf(
                /* translators: 1: subscription name, 2: number of days */
                __('%1$s renews in %2$d day(s).', 'wp-subscription-tracker'),
                '<strong>' . $itemName . '</strong>',
                $daysUntil
            )
        );
        ?>
    </p>
    <table cellpadding="6" cellspacing="0" border="0" style="border-collapse:collapse;">
        <tr><td><strong><?php esc_html_e('Item', 'wp-subscription-tracker'); ?></strong></td><td><?php echo $itemName; ?></td></tr>
        <tr><td><strong><?php esc_html_e('Vendor', 'wp-subscription-tracker'); ?></strong></td><td><?php echo $vendor !== '' ? $vendor : esc_html__('N/A', 'wp-subscription-tracker'); ?></td></tr>
        <tr><td><strong><?php esc_html_e('Renewal Date', 'wp-subscription-tracker'); ?></strong></td><td><?php echo $renewalDate; ?></td></tr>
        <tr><td><strong><?php esc_html_e('Amount', 'wp-subscription-tracker'); ?></strong></td><td><?php echo $formattedPrice; ?></td></tr>
    </table>

    <?php if ($affiliateUrl !== '') : ?>
        <p style="margin:16px 0 0;">
            <strong><?php esc_html_e('Affiliate Renewal Link', 'wp-subscription-tracker'); ?></strong><br />
            <a href="<?php echo $affiliateUrl; ?>" target="_blank" rel="nofollow sponsored noopener">
                <?php esc_html_e('Renew via partner link', 'wp-subscription-tracker'); ?>
            </a>
        </p>
    <?php endif; ?>
</body>
</html>
