<?php
if (! defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap wpst-wrap">
    <h1><?php echo esc_html__('WP Subscription Tracker', 'wp-subscription-tracker'); ?></h1>

    <div class="wpst-actions">
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <input type="hidden" name="action" value="wpst_export_csv" />
            <?php wp_nonce_field('wpst_export_csv'); ?>
            <button class="button"><?php echo esc_html__('Export CSV', 'wp-subscription-tracker'); ?></button>
        </form>
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <input type="hidden" name="action" value="wpst_export_ical" />
            <?php wp_nonce_field('wpst_export_ical'); ?>
            <button class="button"><?php echo esc_html__('Export iCal', 'wp-subscription-tracker'); ?></button>
        </form>
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <input type="hidden" name="action" value="wpst_scan" />
            <?php wp_nonce_field('wpst_scan'); ?>
            <button class="button button-primary"><?php echo esc_html__('Scan for Plugins', 'wp-subscription-tracker'); ?></button>
        </form>
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <input type="hidden" name="action" value="wpst_sync_pricing" />
            <?php wp_nonce_field('wpst_sync_pricing'); ?>
            <button class="button"><?php echo esc_html__('Sync Market Pricing', 'wp-subscription-tracker'); ?></button>
        </form>
    </div>

    <div class="wpst-summary">
        <div class="wpst-card"><strong><?php esc_html_e('Total Monthly', 'wp-subscription-tracker'); ?></strong><span><?php echo esc_html(number_format((float) $totals['monthly'], 2)); ?></span></div>
        <div class="wpst-card"><strong><?php esc_html_e('Total Annual', 'wp-subscription-tracker'); ?></strong><span><?php echo esc_html(number_format((float) $totals['annual'], 2)); ?></span></div>
        <div class="wpst-card"><strong><?php esc_html_e('Active Subscriptions', 'wp-subscription-tracker'); ?></strong><span><?php echo esc_html((string) $totals['active']); ?></span></div>
        <div class="wpst-card"><strong><?php esc_html_e('Next Renewal', 'wp-subscription-tracker'); ?></strong><span><?php echo isset($totals['next']['item_name']) ? esc_html($totals['next']['item_name'] . ' - ' . $totals['next']['renewal_date']) : esc_html__('N/A', 'wp-subscription-tracker'); ?></span></div>
    </div>

    <h2><?php esc_html_e('Add / Edit Subscription', 'wp-subscription-tracker'); ?></h2>
    <div id="wpst-inline-notice" class="notice inline" style="display:none;" role="status" aria-live="polite"></div>
    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" class="wpst-form" id="wpst-subscription-form">
        <input type="hidden" name="action" value="wpst_save_subscription" />
        <input type="hidden" name="id" value="" />
        <?php wp_nonce_field('wpst_save_subscription'); ?>
        <label for="wpst-item-name" class="screen-reader-text"><?php esc_html_e('Subscription name', 'wp-subscription-tracker'); ?></label>
        <input id="wpst-item-name" type="text" name="item_name" placeholder="<?php esc_attr_e('Name', 'wp-subscription-tracker'); ?>" required aria-required="true" />
        <label for="wpst-vendor" class="screen-reader-text"><?php esc_html_e('Vendor', 'wp-subscription-tracker'); ?></label>
        <input id="wpst-vendor" type="text" name="vendor" placeholder="<?php esc_attr_e('Vendor', 'wp-subscription-tracker'); ?>" />
        <label for="wpst-cost" class="screen-reader-text"><?php esc_html_e('Cost', 'wp-subscription-tracker'); ?></label>
        <input id="wpst-cost" type="number" name="cost" placeholder="0.00" step="0.01" min="0" required aria-required="true" />
        <label for="wpst-item-type" class="screen-reader-text"><?php esc_html_e('Item type', 'wp-subscription-tracker'); ?></label>
        <select id="wpst-item-type" name="item_type">
            <option value="other"><?php esc_html_e('Other', 'wp-subscription-tracker'); ?></option>
            <option value="plugin"><?php esc_html_e('Plugin', 'wp-subscription-tracker'); ?></option>
            <option value="theme"><?php esc_html_e('Theme', 'wp-subscription-tracker'); ?></option>
            <option value="service"><?php esc_html_e('Service', 'wp-subscription-tracker'); ?></option>
            <option value="hosting"><?php esc_html_e('Hosting', 'wp-subscription-tracker'); ?></option>
            <option value="domain"><?php esc_html_e('Domain', 'wp-subscription-tracker'); ?></option>
        </select>
        <label for="wpst-billing-cycle" class="screen-reader-text"><?php esc_html_e('Billing cycle', 'wp-subscription-tracker'); ?></label>
        <select id="wpst-billing-cycle" name="billing_cycle">
            <option value="monthly"><?php esc_html_e('Monthly', 'wp-subscription-tracker'); ?></option>
            <option value="annually"><?php esc_html_e('Annually', 'wp-subscription-tracker'); ?></option>
            <option value="lifetime"><?php esc_html_e('Lifetime', 'wp-subscription-tracker'); ?></option>
            <option value="one-time"><?php esc_html_e('One-time', 'wp-subscription-tracker'); ?></option>
        </select>
        <label for="wpst-renewal-date" class="screen-reader-text"><?php esc_html_e('Renewal date', 'wp-subscription-tracker'); ?></label>
        <input id="wpst-renewal-date" type="date" name="renewal_date" />
        <label for="wpst-status" class="screen-reader-text"><?php esc_html_e('Status', 'wp-subscription-tracker'); ?></label>
        <select id="wpst-status" name="status">
            <option value="active"><?php esc_html_e('Active', 'wp-subscription-tracker'); ?></option>
            <option value="expired"><?php esc_html_e('Expired', 'wp-subscription-tracker'); ?></option>
            <option value="cancelled"><?php esc_html_e('Cancelled', 'wp-subscription-tracker'); ?></option>
            <option value="trial"><?php esc_html_e('Trial', 'wp-subscription-tracker'); ?></option>
            <option value="needs_review"><?php esc_html_e('Needs Review', 'wp-subscription-tracker'); ?></option>
        </select>
        <div class="wpst-license-field">
            <label for="wpst-license-key" class="screen-reader-text"><?php esc_html_e('License key', 'wp-subscription-tracker'); ?></label>
            <input id="wpst-license-key" type="password" name="license_key" placeholder="<?php esc_attr_e('License Key', 'wp-subscription-tracker'); ?>" autocomplete="off" aria-describedby="wpst-license-help" />
            <button type="button" class="button button-secondary" id="wpst-toggle-license" aria-controls="wpst-license-key" aria-pressed="false"><?php esc_html_e('Reveal', 'wp-subscription-tracker'); ?></button>
            <small id="wpst-license-help"><?php esc_html_e('Stored encrypted and hidden until you choose to reveal it.', 'wp-subscription-tracker'); ?></small>
        </div>
        <label><input type="checkbox" name="auto_renew" value="1" checked /> <?php esc_html_e('Auto-renew', 'wp-subscription-tracker'); ?></label>
        <label for="wpst-notes" class="screen-reader-text"><?php esc_html_e('Notes', 'wp-subscription-tracker'); ?></label>
        <textarea id="wpst-notes" name="notes" placeholder="<?php esc_attr_e('Notes', 'wp-subscription-tracker'); ?>" aria-describedby="wpst-form-microcopy"></textarea>
        <input type="hidden" name="currency" value="<?php echo esc_attr(get_option('wpst_default_currency', 'CAD')); ?>" />
        <p id="wpst-form-microcopy" class="description"><?php esc_html_e('Tip: leave Renewal Date empty for lifetime or one-time purchases.', 'wp-subscription-tracker'); ?></p>
        <div class="wpst-form-actions">
            <button class="button button-primary" type="submit"><?php esc_html_e('Save', 'wp-subscription-tracker'); ?></button>
            <button class="button" type="button" id="wpst-cancel-edit" style="display:none;"><?php esc_html_e('Cancel Edit', 'wp-subscription-tracker'); ?></button>
        </div>
    </form>

    <h2><?php esc_html_e('Subscriptions', 'wp-subscription-tracker'); ?></h2>
    <div class="wpst-table-toolbar">
        <div class="wpst-filter-buttons" role="group" aria-label="<?php esc_attr_e('Subscription filters', 'wp-subscription-tracker'); ?>">
            <button class="button button-secondary is-active" type="button" data-filter="all"><?php esc_html_e('All', 'wp-subscription-tracker'); ?></button>
            <button class="button button-secondary" type="button" data-filter="plugins"><?php esc_html_e('Plugins', 'wp-subscription-tracker'); ?></button>
            <button class="button button-secondary" type="button" data-filter="themes"><?php esc_html_e('Themes', 'wp-subscription-tracker'); ?></button>
            <button class="button button-secondary" type="button" data-filter="expiring"><?php esc_html_e('Expiring Soon', 'wp-subscription-tracker'); ?></button>
            <button class="button button-secondary" type="button" data-filter="inactive"><?php esc_html_e('Inactive', 'wp-subscription-tracker'); ?></button>
            <button class="button button-secondary" type="button" data-filter="needs_review"><?php esc_html_e('Needs Review', 'wp-subscription-tracker'); ?></button>
        </div>
        <div class="wpst-table-controls">
            <label for="wpst-search" class="screen-reader-text"><?php esc_html_e('Search subscriptions', 'wp-subscription-tracker'); ?></label>
            <input type="search" id="wpst-search" placeholder="<?php esc_attr_e('Search subscriptions', 'wp-subscription-tracker'); ?>" />
            <label for="wpst-sort" class="screen-reader-text"><?php esc_html_e('Sort subscriptions', 'wp-subscription-tracker'); ?></label>
            <select id="wpst-sort">
                <option value="renewal_asc"><?php esc_html_e('Renewal: Soonest', 'wp-subscription-tracker'); ?></option>
                <option value="renewal_desc"><?php esc_html_e('Renewal: Latest', 'wp-subscription-tracker'); ?></option>
                <option value="name_asc"><?php esc_html_e('Name: A-Z', 'wp-subscription-tracker'); ?></option>
                <option value="name_desc"><?php esc_html_e('Name: Z-A', 'wp-subscription-tracker'); ?></option>
                <option value="cost_desc"><?php esc_html_e('Cost: High-Low', 'wp-subscription-tracker'); ?></option>
            </select>
        </div>
    </div>

    <p id="wpst-results-summary" class="description" role="status" aria-live="polite">
        <?php echo esc_html(sprintf(_n('Showing %d subscription.', 'Showing %d subscriptions.', count($rows), 'wp-subscription-tracker'), count($rows))); ?>
    </p>

    <table class="wp-list-table widefat striped">
        <thead>
            <tr>
                <th><?php esc_html_e('Name', 'wp-subscription-tracker'); ?></th>
                <th><?php esc_html_e('Vendor', 'wp-subscription-tracker'); ?></th>
                <th><?php esc_html_e('Your Cost', 'wp-subscription-tracker'); ?></th>
                <th><?php esc_html_e('Market Price', 'wp-subscription-tracker'); ?></th>
                <th><?php esc_html_e('Cycle', 'wp-subscription-tracker'); ?></th>
                <th><?php esc_html_e('Renewal', 'wp-subscription-tracker'); ?></th>
                <th><?php esc_html_e('Status', 'wp-subscription-tracker'); ?></th>
                <th><?php esc_html_e('Actions', 'wp-subscription-tracker'); ?></th>
            </tr>
        </thead>
        <tbody id="wpst-subscription-tbody" data-affiliate-enabled="<?php echo esc_attr(get_option('wpst_affiliate_disabled', '0') === '1' ? '0' : '1'); ?>">
            <?php if (empty($rows)) : ?>
                <tr><td colspan="8"><?php esc_html_e('No subscriptions found.', 'wp-subscription-tracker'); ?></td></tr>
            <?php else : ?>
                <?php foreach ($rows as $row) : ?>
                    <tr data-row='<?php echo esc_attr(wp_json_encode([
                        'id'           => (int) $row['id'],
                        'item_type'    => (string) $row['item_type'],
                        'item_slug'    => (string) $row['item_slug'],
                        'item_name'    => (string) $row['item_name'],
                        'vendor'       => (string) $row['vendor'],
                        'cost'         => (float) $row['cost'],
                        'currency'     => (string) $row['currency'],
                        'billing_cycle'=> (string) $row['billing_cycle'],
                        'renewal_date' => (string) $row['renewal_date'],
                        'auto_renew'   => (int) $row['auto_renew'],
                        'license_key'  => WPST_Encryption::decrypt((string) $row['license_key']),
                        'notes'        => (string) $row['notes'],
                        'status'       => (string) $row['status'],
                        'market_price' => $row['market_price'] !== null ? (float) $row['market_price'] : null,
                        'affiliate_url'=> (string) $row['affiliate_url'],
                    ])); ?>'>
                        <td><?php echo esc_html((string) $row['item_name']); ?></td>
                        <td><?php echo esc_html((string) $row['vendor']); ?></td>
                        <td><?php echo esc_html(number_format((float) $row['cost'], 2) . ' ' . (string) $row['currency']); ?></td>
                        <td><?php echo esc_html($row['market_price'] !== null ? number_format((float) $row['market_price'], 2) . ' ' . (string) $row['currency'] : '—'); ?></td>
                        <td><?php echo esc_html((string) $row['billing_cycle']); ?></td>
                        <td><?php echo esc_html((string) ($row['renewal_date'] ?: '-')); ?></td>
                        <td><?php echo esc_html((string) $row['status']); ?></td>
                        <td>
                            <?php
                            $renewRedirectUrl = wp_nonce_url(
                                admin_url('admin-post.php?action=wpst_subscription_redirect&id=' . (int) $row['id'] . '&context=renew'),
                                'wpst_subscription_redirect_' . (int) $row['id'] . '_renew',
                                'wpst_nonce'
                            );
                            $signupRedirectUrl = wp_nonce_url(
                                admin_url('admin-post.php?action=wpst_subscription_redirect&id=' . (int) $row['id'] . '&context=signup'),
                                'wpst_subscription_redirect_' . (int) $row['id'] . '_signup',
                                'wpst_nonce'
                            );
                            ?>
                            <a href="<?php echo esc_url($renewRedirectUrl); ?>"><?php esc_html_e('Renew', 'wp-subscription-tracker'); ?></a>
                            |
                            <a href="<?php echo esc_url($signupRedirectUrl); ?>"><?php esc_html_e('Sign-up', 'wp-subscription-tracker'); ?></a>
                            |
                            <button type="button" class="button-link wpst-edit-row"><?php esc_html_e('Edit', 'wp-subscription-tracker'); ?></button>
                            |
                            <button type="button" class="button-link-delete wpst-delete-row" data-id="<?php echo esc_attr((string) $row['id']); ?>"><?php esc_html_e('Delete', 'wp-subscription-tracker'); ?></button>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>


    <?php if (! empty($priceAlerts)) : ?>
        <h2><?php esc_html_e('Recent Market Price Changes', 'wp-subscription-tracker'); ?></h2>
        <ul class="wpst-price-alerts">
            <?php foreach ($priceAlerts as $alert) : ?>
                <li><?php echo esc_html((string) $alert['item_name'] . ': ' . number_format((float) $alert['old_price'], 2) . ' → ' . number_format((float) $alert['new_price'], 2) . ' (' . (float) $alert['change_percent'] . '%)'); ?></li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>

    <div class="wpst-donate-callout">
        <p><strong><?php esc_html_e('Support WP Subscription Tracker', 'wp-subscription-tracker'); ?></strong></p>
        <p><?php esc_html_e('If this plugin saves you time, consider supporting future development.', 'wp-subscription-tracker'); ?></p>
        <a class="button button-secondary" href="https://www.web321.co/donate" target="_blank" rel="noopener noreferrer"><?php esc_html_e('Donate', 'wp-subscription-tracker'); ?></a>
    </div>

    <h2><?php esc_html_e('Settings', 'wp-subscription-tracker'); ?></h2>
    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" class="wpst-settings">
        <input type="hidden" name="action" value="wpst_save_settings" />
        <?php wp_nonce_field('wpst_save_settings'); ?>
        <p>
            <label><?php esc_html_e('Default Currency', 'wp-subscription-tracker'); ?></label>
            <select name="default_currency">
                <?php foreach (['CAD', 'USD', 'EUR', 'GBP', 'AUD'] as $currency) : ?>
                    <option value="<?php echo esc_attr($currency); ?>" <?php selected(get_option('wpst_default_currency', 'CAD'), $currency); ?>><?php echo esc_html($currency); ?></option>
                <?php endforeach; ?>
            </select>
        </p>
        <p>
            <label><?php esc_html_e('Notification Email', 'wp-subscription-tracker'); ?></label>
            <input type="email" name="notification_email" value="<?php echo esc_attr((string) get_option('wpst_notification_email', get_option('admin_email'))); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Reminder Intervals', 'wp-subscription-tracker'); ?></label>
            <?php $saved_intervals = (array) get_option('wpst_reminder_intervals', ['30', '7', '1', '0']); ?>
            <?php foreach (['30', '7', '1', '0'] as $interval) : ?>
                <label><input type="checkbox" name="reminder_intervals[]" value="<?php echo esc_attr($interval); ?>" <?php checked(in_array($interval, $saved_intervals, true)); ?> /> <?php echo esc_html($interval . ' day(s)'); ?></label>
            <?php endforeach; ?>
        </p>
        <p>
            <label><input type="checkbox" name="affiliate_disabled" value="1" <?php checked(get_option('wpst_affiliate_disabled', '0'), '1'); ?> /> <?php esc_html_e('Disable affiliate links', 'wp-subscription-tracker'); ?></label>
        </p>
        <p>
            <label><?php esc_html_e('Pricing API Base', 'wp-subscription-tracker'); ?></label>
            <input type="url" name="pricing_api_base" value="<?php echo esc_attr((string) get_option('wpst_pricing_api_base', 'https://shop.web321.co/v1/license_tracker/')); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Pricing API Key', 'wp-subscription-tracker'); ?></label>
            <input type="text" name="pricing_api_key" value="<?php echo esc_attr((string) get_option('wpst_pricing_api_key', '')); ?>" autocomplete="off" />
        </p>
        <p>
            <label><?php esc_html_e('Site API Token', 'wp-subscription-tracker'); ?></label>
            <input type="text" name="site_token" value="<?php echo esc_attr((string) get_option('wpst_site_token', '')); ?>" placeholder="<?php esc_attr_e('Auto-generated if empty', 'wp-subscription-tracker'); ?>" />
            <small><?php esc_html_e('Used for optional token-authenticated REST summary access.', 'wp-subscription-tracker'); ?></small>
        </p>
        <button class="button" type="submit"><?php esc_html_e('Save Settings', 'wp-subscription-tracker'); ?></button>
    </form>
</div>
