<?php

if (! defined('ABSPATH')) {
    exit;
}

class WPST_History
{
    public function init(): void
    {
        add_filter('cron_schedules', [$this, 'add_monthly_schedule']);
        add_action('wpst_monthly_history_snapshot', [$this, 'create_monthly_snapshot']);
    }

    /**
     * @param array<string, array<string, mixed>> $schedules
     * @return array<string, array<string, mixed>>
     */
    public function add_monthly_schedule(array $schedules): array
    {
        if (! isset($schedules['monthly'])) {
            $schedules['monthly'] = [
                'interval' => DAY_IN_SECONDS * 30,
                'display'  => __('Once Monthly', 'wp-subscription-tracker'),
            ];
        }

        return $schedules;
    }

    public function create_monthly_snapshot(): void
    {
        global $wpdb;

        $sourceTable  = $wpdb->prefix . 'subscription_tracker';
        $historyTable = $wpdb->prefix . 'subscription_tracker_history';
        $snapshotDate = gmdate('Y-m-01');
        $rows         = $wpdb->get_results($wpdb->prepare("SELECT id, item_name, cost, currency, billing_cycle, renewal_date, status FROM {$sourceTable} LIMIT %d", 1000000), ARRAY_A);

        foreach ($rows as $row) {
            $wpdb->query($wpdb->prepare(
                "INSERT IGNORE INTO {$historyTable} (subscription_id, snapshot_month, item_name, cost, currency, billing_cycle, renewal_date, status, created_at) VALUES (%d, %s, %s, %f, %s, %s, %s, %s, %s)",
                (int) $row['id'],
                $snapshotDate,
                sanitize_text_field((string) $row['item_name']),
                (float) $row['cost'],
                sanitize_text_field((string) $row['currency']),
                sanitize_text_field((string) $row['billing_cycle']),
                sanitize_text_field((string) $row['renewal_date']),
                sanitize_text_field((string) $row['status']),
                current_time('mysql')
            ));
        }
    }
}
