<?php

if (! defined('ABSPATH')) {
    exit;
}

class WPST_Encryption
{
    public static function encrypt(string $value): string
    {
        if ($value === '') {
            return '';
        }

        $key = substr(hash('sha256', wp_salt('auth')), 0, 32);
        $iv  = random_bytes(16);

        $encrypted = openssl_encrypt($value, 'aes-256-cbc', $key, OPENSSL_RAW_DATA, $iv);
        if ($encrypted === false) {
            return '';
        }

        return base64_encode($iv . $encrypted);
    }

    public static function decrypt(string $value): string
    {
        if ($value === '') {
            return '';
        }

        $decoded = base64_decode($value, true);
        if ($decoded === false || strlen($decoded) < 17) {
            return '';
        }

        $key       = substr(hash('sha256', wp_salt('auth')), 0, 32);
        $iv        = substr($decoded, 0, 16);
        $encrypted = substr($decoded, 16);

        $decrypted = openssl_decrypt($encrypted, 'aes-256-cbc', $key, OPENSSL_RAW_DATA, $iv);

        return is_string($decrypted) ? $decrypted : '';
    }
}
