<?php

if (! defined('ABSPATH')) {
    exit;
}

class WPST_Activator
{
    public static function activate(): void
    {
        global $wpdb;

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';

        $charset_collate = $wpdb->get_charset_collate();
        $table_name      = $wpdb->prefix . 'subscription_tracker';

        $sql = "CREATE TABLE {$table_name} (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            item_type ENUM('plugin','theme','service','hosting','domain','other') NOT NULL DEFAULT 'plugin',
            item_slug VARCHAR(255) NULL,
            item_name VARCHAR(255) NOT NULL,
            vendor VARCHAR(255) NULL,
            vendor_url VARCHAR(512) NULL,
            handled_by ENUM('vendor','management_company') NOT NULL DEFAULT 'vendor',
            management_company VARCHAR(255) NULL,
            cost DECIMAL(10,2) NOT NULL DEFAULT 0.00,
            currency VARCHAR(3) NOT NULL DEFAULT 'USD',
            billing_cycle ENUM('monthly','annually','lifetime','one-time') NOT NULL DEFAULT 'annually',
            renewal_date DATE NULL,
            auto_renew TINYINT(1) NOT NULL DEFAULT 1,
            license_key TEXT NULL,
            notes TEXT NULL,
            status ENUM('active','expired','cancelled','trial','needs_review') NOT NULL DEFAULT 'active',
            is_detected TINYINT(1) NOT NULL DEFAULT 0,
            affiliate_url VARCHAR(512) NULL,
            affiliate_id VARCHAR(100) NULL,
            market_price DECIMAL(10,2) NULL,
            pricing_source_url VARCHAR(512) NULL,
            pricing_last_synced DATETIME NULL,
            created_at DATETIME NOT NULL,
            updated_at DATETIME NOT NULL,
            PRIMARY KEY  (id),
            KEY item_slug (item_slug),
            KEY renewal_date (renewal_date)
        ) {$charset_collate};";

        dbDelta($sql);

        $history_table = $wpdb->prefix . 'subscription_tracker_history';

        $history_sql = "CREATE TABLE {$history_table} (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            subscription_id BIGINT(20) UNSIGNED NOT NULL,
            snapshot_month DATE NOT NULL,
            item_name VARCHAR(255) NOT NULL,
            cost DECIMAL(10,2) NOT NULL DEFAULT 0.00,
            currency VARCHAR(3) NOT NULL DEFAULT 'USD',
            billing_cycle VARCHAR(20) NOT NULL DEFAULT 'annually',
            renewal_date DATE NULL,
            status VARCHAR(30) NOT NULL DEFAULT 'active',
            created_at DATETIME NOT NULL,
            PRIMARY KEY  (id),
            UNIQUE KEY subscription_month (subscription_id, snapshot_month),
            KEY snapshot_month (snapshot_month)
        ) {$charset_collate};";

        dbDelta($history_sql);

        $price_changes_table = $wpdb->prefix . 'subscription_price_changes';

        $price_changes_sql = "CREATE TABLE {$price_changes_table} (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            subscription_id BIGINT(20) UNSIGNED NOT NULL,
            old_price DECIMAL(10,2) NOT NULL DEFAULT 0.00,
            new_price DECIMAL(10,2) NOT NULL DEFAULT 0.00,
            change_percent DECIMAL(8,2) NOT NULL DEFAULT 0.00,
            detected_at DATETIME NOT NULL,
            notified TINYINT(1) NOT NULL DEFAULT 0,
            PRIMARY KEY  (id),
            KEY subscription_id (subscription_id),
            KEY detected_at (detected_at)
        ) {$charset_collate};";

        dbDelta($price_changes_sql);

        if (! wp_next_scheduled('wpst_daily_check')) {
            wp_schedule_event(time() + HOUR_IN_SECONDS, 'daily', 'wpst_daily_check');
        }

        if (! wp_next_scheduled('wpst_daily_pricing_sync')) {
            wp_schedule_event(time() + (2 * HOUR_IN_SECONDS), 'daily', 'wpst_daily_pricing_sync');
        }

        $schedules      = wp_get_schedules();
        $weeklySchedule = isset($schedules['weekly']) ? 'weekly' : 'daily';
        $monthlySchedule = isset($schedules['monthly']) ? 'monthly' : 'daily';

        if (! wp_next_scheduled('wpst_weekly_aff_sync')) {
            wp_schedule_event(time() + DAY_IN_SECONDS, $weeklySchedule, 'wpst_weekly_aff_sync');
        }

        if (! wp_next_scheduled('wpst_monthly_history_snapshot')) {
            wp_schedule_event(time() + DAY_IN_SECONDS, $monthlySchedule, 'wpst_monthly_history_snapshot');
        }

        add_option('wpst_default_currency', 'CAD');
        add_option('wpst_notification_email', get_option('admin_email'));
        add_option('wpst_reminder_intervals', ['30', '7', '1', '0']);
        add_option('wpst_affiliate_disabled', '0');
        add_option('wpst_reminder_cleanup_month', '');
        add_option('wpst_site_token', wp_generate_password(32, false, false));
        add_option('wpst_pricing_api_base', 'https://shop.web321.co/v1/license_tracker/');
        add_option('wpst_pricing_api_key', '');
        add_option('wpst_last_pricing_sync', '');
        $schemaVersion = defined('WPST_VERSION') ? WPST_VERSION : '0.1.0';
        update_option('wpst_schema_version', $schemaVersion);
    }
}
