# WP Subscription Tracker: End-User Guide

This guide explains what the plugin does, how to set it up, and how to keep your subscription data useful over time.

## What the plugin is for

WP Subscription Tracker gives you one admin dashboard to manage paid WordPress plugin/theme subscriptions:

- Track what each subscription costs.
- Track renewal dates and status.
- Estimate monthly and annual spending.
- Export your data for reporting or reminders.

## Prerequisites

- WordPress 6.0+
- PHP 8.0+
- Administrator access to your WordPress site

## Installation

1. Install the plugin (zip upload or copy into `wp-content/plugins/`).
2. Activate **WP Subscription Tracker** from **Plugins**.
3. Go to **Tools > Subscription Tracker**.

## First-time setup checklist

Use this checklist after first activation:

1. **Run auto-detection** to populate likely paid items.
2. **Review “Needs Review” items** and classify them.
3. **Add costs and billing cycles** for paid items.
4. **Set renewal dates** for recurring subscriptions.
5. **Mark auto-renew on/off** per subscription.
6. **Set status** (Active, Trial, Expired, Cancelled).
7. **Confirm dashboard totals** match your expectations.

## Feature walkthrough

### 1) Detection and inventory

The detector looks at installed plugins/themes and flags likely paid products. Use this as a starting point, then confirm each item manually for accuracy.

### 2) Subscription records

Each record can include:

- Name and vendor
- Cost and currency
- Billing cycle (monthly, annual, lifetime, one-time)
- Renewal date
- Auto-renew state
- Notes and internal context
- Current status

### 3) Dashboard totals

The summary cards help you quickly understand:

- Estimated monthly spend
- Estimated annual spend
- Number of active subscriptions
- Next upcoming renewal

### 4) Exports

- **CSV export:** best for spreadsheet analysis and bookkeeping.
- **iCal export:** best for calendar reminders and date visibility.

### 5) Reminder behavior

Use built-in reminder settings to keep renewals visible before charges occur.

## Recommended maintenance routine

- **Weekly:** Check upcoming renewals and add newly installed paid tools.
- **Monthly:** Verify prices against vendor invoices.
- **Quarterly:** Review unused or duplicated subscriptions.
- **Before annual renewals:** export CSV and confirm budget allocations.

## Affiliate links (optional)

The plugin can optionally fetch matching affiliate renewal links from:

- `https://web321.co/aff_links.xml`

Notes:

- This fetch is optional and can be turned off in settings.
- The request is for link/feed data only; local subscription records are not transmitted.

## Troubleshooting

### Totals look wrong

- Confirm each paid item has a cost.
- Confirm billing cycle is correct.
- Check status (expired/cancelled items may affect your expected totals differently than active items).

### Missing expected plugin/theme in detector

- Add it manually as a subscription record.
- Include notes so future reviews remain clear.

### Renewal dates are incomplete

- Fill dates incrementally as invoices/emails arrive.
- Use iCal export once enough dates are populated.

## Quick onboarding template for teams

If multiple admins manage the same site, align on:

- Naming conventions for records
- Currency standards
- How statuses are applied
- A fixed review schedule (for example: first Monday each month)

## Where to start right now

If you only have 10 minutes:

1. Run detection.
2. Enter costs for top 5 most expensive subscriptions.
3. Add renewal dates for anything renewing in the next 90 days.
4. Export iCal and place renewals on your main calendar.
