<?php

declare(strict_types=1);

namespace WPST\PricingApi;

use PDO;

final class Database
{
    public static function connect(Config $config): PDO
    {
        $pdo = new PDO($config->dbDsn(), $config->dbUser(), $config->dbPass(), [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ]);

        return $pdo;
    }
}
