<?php

declare(strict_types=1);

namespace WPST\PricingApi;

final class Config
{
    /** @var array<string, mixed> */
    private array $env;

    public function __construct(?array $env = null)
    {
        $this->env = $env ?? $_ENV;
    }

    public function dbDsn(): string
    {
        return (string) ($this->env['WPST_PRICING_DB_DSN'] ?? '');
    }

    public function dbUser(): string
    {
        return (string) ($this->env['WPST_PRICING_DB_USER'] ?? '');
    }

    public function dbPass(): string
    {
        return (string) ($this->env['WPST_PRICING_DB_PASS'] ?? '');
    }

    public function requireSiteToken(): bool
    {
        return (bool) (int) ($this->env['WPST_PRICING_REQUIRE_SITE_TOKEN'] ?? 1);
    }
}
