<?php

declare(strict_types=1);

namespace WPST\PricingApi;

use PDO;

final class Auth
{
    private PDO $pdo;
    private bool $requireSiteToken;

    public function __construct(PDO $pdo, bool $requireSiteToken)
    {
        $this->pdo = $pdo;
        $this->requireSiteToken = $requireSiteToken;
    }

    /**
     * @return array<string, mixed>|null
     */
    public function authenticate(string $method, array $body): ?array
    {
        $header = (string) ($_SERVER['HTTP_AUTHORIZATION'] ?? '');
        if (! preg_match('/^Bearer\s+(.+)$/i', $header, $matches)) {
            return null;
        }

        $apiKey = trim($matches[1]);
        if ($apiKey === '') {
            return null;
        }

        $hash = hash('sha256', $apiKey);
        $stmt = $this->pdo->prepare('SELECT id, name, site_token, active FROM api_clients WHERE api_key_hash = :hash LIMIT 1');
        $stmt->execute([':hash' => $hash]);
        $client = $stmt->fetch();

        if (! is_array($client) || (int) ($client['active'] ?? 0) !== 1) {
            return null;
        }

        if ($this->requireSiteToken && strtoupper($method) === 'POST') {
            $postedSiteToken = trim((string) ($body['site_token'] ?? ''));
            $storedSiteToken = trim((string) ($client['site_token'] ?? ''));
            if ($storedSiteToken !== '' && ! hash_equals($storedSiteToken, $postedSiteToken)) {
                return null;
            }
        }

        $this->pdo->prepare('UPDATE api_clients SET last_seen_at = UTC_TIMESTAMP() WHERE id = :id')->execute([
            ':id' => (int) $client['id'],
        ]);

        return $client;
    }
}
