CREATE TABLE api_clients (
    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(191) NOT NULL,
    api_key_hash CHAR(64) NOT NULL UNIQUE,
    site_token VARCHAR(191) DEFAULT NULL,
    active TINYINT(1) NOT NULL DEFAULT 1,
    last_seen_at DATETIME DEFAULT NULL,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE products (
    id VARCHAR(32) PRIMARY KEY,
    slug VARCHAR(191) NOT NULL UNIQUE,
    name VARCHAR(255) NOT NULL,
    provider VARCHAR(191) DEFAULT NULL,
    marketplace VARCHAR(64) DEFAULT NULL,
    type ENUM('plugin','theme','service') NOT NULL,
    product_url TEXT DEFAULT NULL,
    affiliate_url TEXT DEFAULT NULL,
    active TINYINT(1) NOT NULL DEFAULT 1,
    last_updated DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_type_marketplace (type, marketplace),
    INDEX idx_updated (last_updated)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE product_prices (
    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    product_id VARCHAR(32) NOT NULL,
    billing_cycle ENUM('monthly','annual','lifetime') NOT NULL,
    price DECIMAL(10,2) NOT NULL,
    currency CHAR(3) NOT NULL DEFAULT 'USD',
    is_current TINYINT(1) NOT NULL DEFAULT 1,
    recorded_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE,
    INDEX idx_product_current (product_id, is_current),
    INDEX idx_recorded (recorded_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE price_changes (
    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    product_id VARCHAR(32) NOT NULL,
    change_type ENUM('increase','decrease','new') NOT NULL,
    field VARCHAR(128) NOT NULL,
    old_value DECIMAL(10,2) DEFAULT NULL,
    new_value DECIMAL(10,2) DEFAULT NULL,
    percent_change DECIMAL(8,2) DEFAULT NULL,
    detected_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE,
    INDEX idx_changes_detected (detected_at),
    INDEX idx_changes_product (product_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
