<?php

declare(strict_types=1);

use WPST\PricingApi\Auth;
use WPST\PricingApi\Config;
use WPST\PricingApi\Database;
use WPST\PricingApi\Http;
use WPST\PricingApi\ProductRepository;

require_once __DIR__ . '/../src/Config.php';
require_once __DIR__ . '/../src/Database.php';
require_once __DIR__ . '/../src/Http.php';
require_once __DIR__ . '/../src/Auth.php';
require_once __DIR__ . '/../src/ProductRepository.php';

$uri = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?: '/';
$method = strtoupper((string) ($_SERVER['REQUEST_METHOD'] ?? 'GET'));
$path = rtrim($uri, '/');

$config = new Config();
$pdo = Database::connect($config);
$repo = new ProductRepository($pdo);
$body = Http::readJsonBody();
$auth = new Auth($pdo, $config->requireSiteToken());

$client = $auth->authenticate($method, $body);
if ($client === null) {
    Http::json(['error' => 'Unauthorized'], 401);
    exit;
}

if ($path === '/v1/pricing/products' && $method === 'GET') {
    Http::json($repo->listProducts($_GET));
    exit;
}

if (preg_match('#^/v1/pricing/products/([a-z0-9\-]+)$#', $path, $matches) && $method === 'GET') {
    $product = $repo->getProductBySlug($matches[1]);
    if ($product === null) {
        Http::json(['error' => 'Not found'], 404);
    } else {
        Http::json(['data' => $product]);
    }
    exit;
}

if ($path === '/v1/pricing/batch' && $method === 'POST') {
    $slugs = $body['slugs'] ?? [];
    if (! is_array($slugs)) {
        Http::json(['error' => 'Invalid request'], 422);
        exit;
    }
    Http::json(['data' => $repo->getBatchBySlugs($slugs)]);
    exit;
}

if ($path === '/v1/pricing/search' && $method === 'GET') {
    $query = trim((string) ($_GET['q'] ?? ''));
    if ($query === '') {
        Http::json(['error' => 'Missing q'], 422);
        exit;
    }
    Http::json($repo->search($query, $_GET));
    exit;
}

if ($path === '/v1/pricing/changes' && $method === 'GET') {
    $since = isset($_GET['since']) ? (string) $_GET['since'] : null;
    $includeMinor = isset($_GET['include_minor']) && (string) $_GET['include_minor'] === 'true';
    Http::json($repo->changes($since, $includeMinor));
    exit;
}

Http::json(['error' => 'Not found'], 404);
