# Central Pricing API (PHP 8 + MySQL)

This service implements the `/v1/pricing/*` endpoints consumed by WP Subscription Tracker when centralized pricing data is enabled.

## Requirements

- PHP 8.0+
- MySQL 8.0+

## Quick start

1. Create a MySQL database and import schema:

   ```bash
   mysql -u root -p wpst_pricing < central-pricing-api/schema.sql
   ```

2. Configure environment variables:

   ```bash
   export WPST_PRICING_DB_DSN='mysql:host=127.0.0.1;port=3306;dbname=wpst_pricing;charset=utf8mb4'
   export WPST_PRICING_DB_USER='wpst'
   export WPST_PRICING_DB_PASS='secret'
   export WPST_PRICING_REQUIRE_SITE_TOKEN='1'
   ```

3. Start the API server:

   ```bash
   php -S 0.0.0.0:8080 -t central-pricing-api/public
   ```

4. Verify API health quickly:

   ```bash
   curl -i http://127.0.0.1:8080/v1/pricing/products
   ```

## API client bootstrap

Store hashed API keys in `api_clients`:

```sql
INSERT INTO api_clients (name, api_key_hash, site_token)
VALUES ('Example Site', SHA2('your-plain-api-key', 256), 'site-token-from-plugin');
```

## Endpoints

- `GET /v1/pricing/products`
- `GET /v1/pricing/products/{slug}`
- `POST /v1/pricing/batch`
- `GET /v1/pricing/search?q=...`
- `GET /v1/pricing/changes?since=YYYY-MM-DD&include_minor=true`

All endpoints require:

- `Authorization: Bearer <api-key>`

For POST `/v1/pricing/batch`, include:

```json
{ "slugs": ["elementor-pro"], "site_token": "..." }
```

## Plugin integration checklist

In WP Subscription Tracker settings, confirm:

1. Pricing API base URL points to this service.
2. API key matches a hashed value in `api_clients`.
3. Site token matches the `site_token` column when token validation is enabled.
4. Remote requests are allowed by server firewall and WordPress host.

## Common setup issues

- **401 Unauthorized:** API key mismatch or missing `Authorization` header.
- **403 Forbidden:** `site_token` validation failed when required.
- **500 errors on startup:** verify DSN/user/password and that schema was imported.
