<?php
/**
 * Plugin Name:			LearnDash Quiz Viewer From Web321
 * Plugin URI:			https://web321.co/plugins/ld-quiz-viewer
 * Description:			Displays the result of LearnDash quizzes.
 * Version:				1.0.1
 * Requires at least:	6.0
 * Tested up to:		6.4
 * Author:				dewolfe001
 * Author URI:			https://web321.co/
 * Donate:				https://www.paypal.com/paypalme/web321co/20/
 * Text Domain:			w321-ldq
 * Domain Path:			/languages
 */

defined( 'ABSPATH' ) || exit;
define( 'WLDQ_NAME', plugin_basename( __FILE__ ));
define( 'WLDQ_DIR', plugin_dir_path(__FILE__));
define( 'WLDQ_URL', plugin_dir_url(__FILE__));


add_filter('plugin_row_meta', 'wldq_row_meta', 10, 2);

// donation link
function wldq_row_meta( $links, $file ) {    
    if (WLDQ_NAME == $file ) {
        $row_meta = array(
          'donate'    => '<a href="' . esc_url( 'https://www.paypal.com/paypalme/web321co/20/' ) . '" target="_blank" aria-label="' . esc_attr__( 'Donate', 'w321-ldq' ) . '" >' . esc_html__( 'Donate', 'w321-ldq' ) . '</a>'
        );
        return array_merge( $links, $row_meta );
    }
    return (array) $links;
}


function wldq_shortcode() {
    // Check if the user is logged in
    if ( ! is_user_logged_in() ) {
        return 'You must be logged in to view this page.';
    }

    $current_user_id = get_current_user_id();

    // Check if the user is an administrator or a LearnDash Group Leader
    if ( ! current_user_can( 'manage_options' ) && ! learndash_is_group_leader_user( $current_user_id ) ) {
        return 'You do not have permission to view this page.';
    }

    // Get quizId and userId from $_GET parameters
    $quizId = isset( $_GET['quizId'] ) ? intval( $_GET['quizId'] ) : 0;
    $userId = isset( $_GET['userId'] ) ? intval( $_GET['userId'] ) : 0;
    $refId = isset( $_GET['refId'] ) ? intval( $_GET['refId'] ) : 0;    

    if ( ! $quizId || ! $userId ) {
        $pattern = '/quizId(\d+)userId(\d+)refId(\d+)/';
        
        // Use preg_match to extract the values
        if (preg_match($pattern, $_SERVER['QUERY_STRING'], $matches)) {
            // $matches[1] contains the quizId
            $quizId = $matches[1];
        
            // $matches[2] contains the userId
            $userId = $matches[2];
        
            // $matches[3] contains the refId
            $refId = $matches[3];
        }
    
        // $url = sprintf('https://%s/%s/?quizId%d&userId%d&refId%d', 'jhmj.ca', 'quiz-details', $quiz_id, $user_id, $statistic_ref_id);
    }

    if ( ! $quizId || ! $userId ) {
        return 'Invalid quiz ID or user ID.';
    }

    // Generate the nonce required for the AJAX call
    // $nonce = wp_create_nonce( 'wpProQuiz_statistics' );
    
    $nonce = wp_create_nonce( 'statistic_nonce_' . $refId . '_' . get_current_user_id() . '_' . $userId );
    
    // Prepare data for the AJAX request
    $data = array(
        'action' => 'wp_pro_quiz_admin_ajax_statistic_load_user',
        'func'   => 'statisticLoadUser',
        'data'   => array(
            'quizId'          => $quizId,
            'userId'          => $userId,
            'refId'           => $refId,
            'statistic_nonce' => $nonce,
            'avg'             => 0,
        ),
    );

    // Prepare cookies for authentication
    $cookies = array();
    foreach ( $_COOKIE as $name => $value ) {
        $cookies[] = new WP_Http_Cookie( array( 'name' => $name, 'value' => $value ) );
    }

    // Perform the AJAX request to admin-ajax.php
    $response = wp_remote_post( admin_url( 'admin-ajax.php' ), array(
        'body'    => $data,
        'cookies' => $cookies,
    ) );

    if ( is_wp_error( $response ) ) {
        return 'Error fetching data.';
    }

    $json = wp_remote_retrieve_body( $response );
    $output = json_decode($json, TRUE);
    $body = $output['html'];

    // Start output buffering to capture output
    ob_start();
    
    print $body;
    ?>
    <style>
        .wpProQuiz_questionList {
            list-style-type: none;
            text-align: left;
        }
        
    .wpProQuiz_update, #wpProQuiz_resetUserStatistic {
        display: none;
    }
    
    </style>
    <script>
    jQuery(document).ready(function($) {
        // Attach a click event listener to the links with class 'statistic_data'
        $('a.statistic_data').on('click', function(e) {
            e.preventDefault(); // Prevent the default anchor behavior
    
            // Find the parent <tr> element of the clicked link
            var currentRow = $(this).closest('tr');
    
            // Find the next <tr> element (the one with display: none)
            var hiddenRow = currentRow.next('tr');
    
            // Toggle the visibility of the hidden <tr>
            hiddenRow.toggle();
        });
    });
    </script>
    <?php

    // Return the buffered output
    return ob_get_clean();

}

// Register the shortcode
add_shortcode( 'ld_quiz_statistics', 'wldq_shortcode' );

// Add the URL to the mix

// Hook into the LearnDash quiz email filter
add_filter( 'learndash_quiz_email_note_admin_message', 'wldq_admin_email_message', 10, 6 );

/**
 * Modify the admin email message when a quiz result is sent.
 *
 * @param string $admin_mail_message The original email message.
 * @param array  $r The result data for the quiz.
 * @param object $quiz The quiz object.
 * @param array  $result The user's result data.
 * @param array  $categories The quiz categories.
 *
 * @return string Modified email message.
 */
function wldq_admin_email_message( $admin_mail_message, $r, $quiz, $result, $categories ) {

    global $wpdb;
    
    // Get user ID, quizId, and quiz from POST data
    $user_id  = get_current_user_id(); // Assuming you're getting the user ID
    $quiz_id  = isset($_POST['quizId']) ? intval($_POST['quizId']) : 0;
    $quiz_post_id = isset($_POST['quiz']) ? intval($_POST['quiz']) : 0;
    
    if ($user_id && $quiz_id && $quiz_post_id) {
        // Get the table name with the correct prefix
        $table_name = $wpdb->prefix . 'learndash_pro_quiz_statistic_ref';
        
        // Prepare the SQL query to get the latest matching refId
        $query = $wpdb->prepare(
            "SELECT statistic_ref_id 
            FROM $table_name 
            WHERE user_id = %d 
            AND quiz_id = %d 
            AND quiz_post_id = %d 
            ORDER BY statistic_ref_id DESC 
            LIMIT 1",
            $user_id, $quiz_id, $quiz_post_id
        );
    
        // Execute the query
        $statistic_ref_id = $wpdb->get_var($query);
    
        if ($statistic_ref_id) {
            $learndash_settings_emails = get_option('learndash_settings_emails_quiz_view_url', '');
            $option_url = $learndash_settings_emails['quiz_view_url'];


            $url = sprintf('%s?quizId%duserId%drefId%d', $option_url, $quiz_id, $user_id, $statistic_ref_id);
            
            // Replace any occurrence of &#038; with &
            $url = str_replace('&#038;', '&', $url);
            
            // Output the URL
            $custom_message = "\nTo view the quiz: " .  esc_url($url);

        
            // Append the custom message to the original email message
            $admin_mail_message .= $custom_message;
        }
    }

    return $admin_mail_message;
}
 
// add_action('learndash_init', 'wldq_init');
add_action('learndash_settings_sections_init', 'wldq_init', 16);

function wldq_init() {
    // Your code that relies on LearnDash being available
    if ( class_exists( 'LearnDash_Settings_Section' ) ) {
        // Now LearnDash is available, you can use the class safely
        // Initialize your custom LearnDash-related code here

        /**
         * Class to add the Quiz View URL setting to LearnDash Email Settings page.
         */
        class LearnDash_Settings_Section_Emails_Quiz_View_URL_Settings extends LearnDash_Settings_Section {
        
            protected function __construct() {
                $this->settings_page_id = 'learndash_lms_emails';
                $this->setting_option_key = 'learndash_settings_emails_quiz_view_url';
                $this->setting_field_prefix = 'learndash_settings_emails_quiz_view_url';
                $this->settings_section_key = 'settings_emails_quiz_view_url';
                $this->settings_section_label = esc_html__( 'Quiz View URL Settings', 'learndash' );
                parent::__construct();
            }
        
            /**
             * Load the default values for the setting.
             */
            public function load_settings_values() {
                parent::load_settings_values();
                if ( ! isset( $this->setting_option_values['quiz_view_url'] ) ) {
                    $this->setting_option_values['quiz_view_url'] = '';
                }
            }
        
            /**
             * Add the setting field for the Quiz View URL.
             */
            public function load_settings_fields() {
                $this->setting_option_fields['quiz_view_url'] = array(
                    'name'        => 'quiz_view_url',
                    'label'       => esc_html__( 'Quiz View URL', 'learndash' ),
                    'type'        => 'text',
                    'help_text'   => esc_html__( 'Enter the URL for the quiz view page.', 'learndash' ),
                    'value'       => $this->setting_option_values['quiz_view_url'],
                    'placeholder' => esc_html__( 'https://example.com/quiz-view', 'learndash' ),
                );
        
                parent::load_settings_fields();
            }
        }

        LearnDash_Settings_Section_Emails_Quiz_View_URL_Settings::add_section_instance();
        error_log('WE HAVE IT!');        
    }
}

/*
add_action(
	'learndash_settings_sections_init',
	function() {
		LearnDash_Settings_Section_Emails_Quiz_View_URL_Settings::add_section_instance();
	}, 20
);
*/



