<?php



    public function iffy_enqueue_admin_assets($hook) {
        // Only load on our Tabular pages.
        if ( strpos($hook, 'tabular3') === false && strpos($hook, 'edit.php') === false ) {
            return;
        }
    
        // Use WordPress’ built-in jQuery.
        wp_enqueue_script('jquery');
    
        // Enqueue DataTables and its extensions from the plugin's assets sub-directory.
        wp_enqueue_script(
            'datatables-js',
            $this->plugin_url . 'assets/datatables/datatables.js',
            array('jquery'),
            '2.2.2',
            true
        );
        wp_enqueue_script(
            'datatables-buttons-js',
            $this->plugin_url . 'assets/datatables/dataTables.buttons.js',
            array('datatables-js'),
            '3.2.2',
            true
        );
        wp_enqueue_script(
            'buttons-datatables-js',
            $this->plugin_url . 'assets/datatables/buttons.dataTables.js',
            array('datatables-buttons-js'),
            '3.2.2',
            true
        );
        wp_enqueue_script(
            'datatables-select-js',
            $this->plugin_url . 'assets/datatables/dataTables.select.js',
            array('datatables-js'),
            '3.0.0',
            true
        );
        wp_enqueue_script(
            'select-datatables-js',
            $this->plugin_url . 'assets/datatables/select.dataTables.js',
            array('datatables-select-js'),
            '3.0.0',
            true
        );
        wp_enqueue_script(
            'datatables-datetime-js',
            $this->plugin_url . 'assets/datatables/dataTables.dateTime.min.js',
            array('datatables-js'),
            '1.5.5',
            true
        );
        
        // Enqueue DataTables Editor scripts from local assets.
        wp_enqueue_script(
            'datatables-editor-js',
            $this->plugin_url . 'assets/datatables/dataTables.editor.js',
            array('datatables-js'),
            'your-version',
            true
        );
        wp_enqueue_script(
            'editor-datatables-js',
            $this->plugin_url . 'assets/datatables/editor.dataTables.js',
            array('datatables-editor-js'),
            'your-version',
            true
        );
    
        // Enqueue corresponding CSS files from your plugin's assets.
        wp_enqueue_style(
            'datatables-css',
            $this->plugin_url . 'assets/datatables/dataTables.css',
            array(),
            '2.2.2'
        );
        wp_enqueue_style(
            'datatables-buttons-css',
            $this->plugin_url . 'assets/datatables/buttons.dataTables.css',
            array(),
            '3.2.2'
        );
        wp_enqueue_style(
            'datatables-select-css',
            $this->plugin_url . 'assets/datatables/select.dataTables.css',
            array(),
            '3.0.0'
        );
        wp_enqueue_style(
            'datatables-datetime-css',
            $this->plugin_url . 'assets/datatables/dataTables.dateTime.min.css',
            array(),
            '1.5.5'
        );
        wp_enqueue_style(
            'datatables-editor-css',
            $this->plugin_url . 'assets/datatables/editor.dataTables.css',
            array(),
            'your-version'
        );
    
        // Enqueue your custom Tabular3 admin JavaScript.
        wp_enqueue_script(
            'tabular3-admin',
            $this->plugin_url . 'assets/js/tabular3-admin.js',
            array(
                'jquery',
                'datatables-js',
                'datatables-editor-js'
            ),
            '1.0',
            true
        );
    
        // Pass PHP variables to your JavaScript.
        wp_localize_script('tabular3-admin', 'tabular3', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce'    => wp_create_nonce('tabular3_nonce')
        ));
    
        // For draggable (sortable) fields.
        wp_enqueue_script('jquery-ui-sortable');
        wp_enqueue_style('jquery-ui-css', 'https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css');
    }




    public function old_ajax_get_posts() {
        // Verify the nonce.
        if ( ! isset($_POST['nonce']) || ! wp_verify_nonce($_POST['nonce'], 'tabular3_nonce') ) {
            wp_send_json_error('Invalid nonce');
        }
        $post_type = isset($_POST['post_type']) ? sanitize_key($_POST['post_type']) : 'post';

        // DataTables parameters.
        $start  = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $length = isset($_POST['length']) ? intval($_POST['length']) : 10;
        $search = isset($_POST['search']['value']) ? sanitize_text_field($_POST['search']['value']) : '';

        $args = array(
            'post_type'      => $post_type,
            'posts_per_page' => $length,
            'offset'         => $start,
            's'              => $search,
        );

        // (Optional) Extend these args with tax_query or meta_query
        // so that a taxonomy term’s name is searchable even if stored as an ID.

        $query = new WP_Query( $args );
        $data  = array();

        // Retrieve the field settings.
        $fields_option = get_option('tabular3_' . $post_type . '_fields', array());
        foreach ( $query->posts as $post ) {
            $row = array();
            foreach ( $fields_option as $field_key ) {
                $value = "";
                $field_settings = get_option('tabular3_' . $post_type . '_field_' . sanitize_key($field_key), array());
                if ( isset($field_settings['visibility']) && $field_settings['visibility'] == 'hidden' ) {
                    continue;
                }
                

                // Assume the field is a custom meta; if empty, check for taxonomy terms.
                if ( empty($value) ) {                
                    $value = get_post_meta($post->ID, $field_key, true);
                }
                if ( empty($value) ) {
                    $taxonomies = get_object_taxonomies($post_type);
                    if ( in_array($field_key, $taxonomies) ) {
                        $terms = wp_get_post_terms($post->ID, $field_key, array("fields" => "names"));
                        $value = implode(', ', $terms);
                    }
                }
                $row[$field_key] = $value;
            }
            // Always include the post ID.
            $row['ID'] = $post->ID;
            $data[] = $row;
        }

        // Prepare the DataTables response.
        $response = array(
            "draw"            => isset($_POST['draw']) ? intval($_POST['draw']) : 0,
            "recordsTotal"    => intval($query->found_posts),
            "recordsFiltered" => intval($query->found_posts),
            "data"            => $data,
        );
        wp_send_json($response);
    }


/*------------*/

                                            <li class="tabular3-field-item">
                                                <strong><?php echo ucwords(esc_html($field_key)); ?></strong><br/>
                                                <label><span>Display:</span>
                                                    <label>
                                                        <input type="radio" name="fields[<?php echo esc_attr($post_type); ?>][<?php echo esc_attr($field_key); ?>][display]" value="yes" <?php checked( isset($settings['display']) ? $settings['display'] : 'yes', 'yes' ); ?> />
                                                        Yes
                                                    </label>
                                                    <label>
                                                        <input type="radio" name="fields[<?php echo esc_attr($post_type); ?>][<?php echo esc_attr($field_key); ?>][display]" value="no" <?php checked( isset($settings['display']) ? $settings['display'] : 'yes', 'no' ); ?> />
                                                        No
                                                    </label>
                                                </label>
                                                <label><span>Label:</span>
                                                    <input type="text" name="fields[<?php echo esc_attr($post_type); ?>][<?php echo esc_attr($field_key); ?>][label]" value="<?php echo esc_attr($settings['label']); ?>" />
                                                </label>
                                                <label><span>Visibility:</span>
                                                    <select name="fields[<?php echo esc_attr($post_type); ?>][<?php echo esc_attr($field_key); ?>][visibility]">
                                                        <option value="edit_view" <?php selected($settings['visibility'], 'edit_view'); ?>>Edit/View</option>
                                                        <option value="view" <?php selected($settings['visibility'], 'view'); ?>>View</option>
                                                        <option value="hidden" <?php selected($settings['visibility'], 'hidden'); ?>>Hidden</option>
                                                    </select>
                                                </label>
                                                <label><span>Input Format:</span>
                                                    <select name="fields[<?php echo esc_attr($post_type); ?>][<?php echo esc_attr($field_key); ?>][input_format]" <?php if ($settings['visibility'] == 'view') echo 'disabled'; ?>>
                                                        <option value="text" <?php selected($settings['input_format'], 'text'); ?>>Text</option>
                                                        <option value="number" <?php selected($settings['input_format'], 'number'); ?>>Number</option>
                                                        <option value="date" <?php selected($settings['input_format'], 'date'); ?>>Date</option>                                                        
                                                        <option value="textarea" <?php selected($settings['input_format'], 'textarea'); ?>>Textarea</option>
                                                        <option value="wysiwyg" <?php selected($settings['input_format'], 'wysiwyg'); ?>>WYSIWYG</option>
                                                        <option value="media_upload" <?php selected($settings['input_format'], 'media_upload'); ?>>Media Upload</option>
                                                        <option value="taxonomy_autocomplete" <?php selected($settings['input_format'], 'taxonomy_autocomplete'); ?>>Taxonomy Autocomplete</option>
                                                        <option value="select" <?php selected($settings['input_format'], 'select'); ?>>Select List</option>
                                                        <option value="relationship" <?php selected($settings['input_format'], 'relationship'); ?>>Relationship</option>
                                                        <option value="readonly" <?php selected($settings['input_format'], 'readonly'); ?>>Real Only</option>
                                                        <option value="hidden" <?php selected($settings['input_format'], 'hidden'); ?>>Hidden</option>
                                                    </select>
                                                </label>
                                            </li>
                                            
                                            
/* -------------------------- */



    public function umm_enqueue_admin_assets($hook) {
        // Only load on our Tabular pages.
        if ( strpos($hook, 'tabular3') === false && strpos($hook, 'edit.php') === false ) {
            return;
        }
        // Use WordPress’ built-in jQuery.
        wp_enqueue_script('jquery');
    
        // Enqueue DataTables and its extensions from the plugin's assets sub-directory.
        wp_enqueue_script(
            'datatables-js',
            $this->plugin_url . 'assets/datatables/datatables.js',
            array('jquery'),
            '2.2.2',
            true
        );

        wp_enqueue_style(
            'datatables-css',
            $this->plugin_url . 'assets/datatables/datatables.css',
            array(),
            '1.01'
        );

        wp_enqueue_script(
            'bootstrap-js',
            'https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.2/js/bootstrap.min.js',
            array('jquery'),
            '4.5.2',
            true
        );

        wp_enqueue_script(
            'tabular3-bootstrap',
            $this->plugin_url . 'assets/datatables/js/editor.bootstrap4.min.js',
            array(
                'jquery',
                'datatables-js',
                'bootstrap-js'
            ),
            '1.0',
            true
        );
    
        // Enqueue your custom Tabular3 admin JavaScript.
        wp_enqueue_script(
            'tabular3-admin',
            $this->plugin_url . 'assets/js/tabular3-admin.js',
            array(
                'jquery',
                'datatables-js'
            ),
            '1.0',
            true
        );
    
        wp_enqueue_style(
            'datatables-admin-css',
            $this->plugin_url . 'assets/css/tabular3-admin.css',
            array(),
            '1.0.1'
        );    
    
    
        wp_enqueue_style(
            'datatables-bootstrap-css',
            $this->plugin_url . 'assets/datatables/css/editor.bootstrap4.min.css',
            array(),
            '1.0.1'
        );        

        wp_enqueue_style(
            'datatables-cloudflare-css',
            'https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.2/css/bootstrap.css',
            array(),
            '4.5.2'
        );        
    
        wp_enqueue_style(
            'datatables-cdn-css',
            'https://cdn.datatables.net/2.2.2/css/dataTables.bootstrap4.css',
            array(),
            '2.2.2'
        );        
    
        // Pass PHP variables to your JavaScript.
        wp_localize_script('tabular3-admin', 'tabular3', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce'    => wp_create_nonce('tabular3_nonce')
        ));
    
    
        if ($_GET['page'] == 'tabular3-settings') {
            // For draggable (sortable) fields.
            wp_enqueue_style('jquery-ui-css', 'https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css');
            wp_enqueue_script('jquery-ui-sortable');            
        }
    }


/* -------------------------------------- */


                    foreach ( $fields as $field_key => $field_settings ) {
                        // Allow filtering of the field settings.
                        $field_settings = apply_filters('tabular3_save_field_settings', $field_settings, $post_type, $field_key);
                        update_option('tabular3_' . $post_type . '_field_' . sanitize_key($field_key), $field_settings);
                    }
                    
                    
/* -------------------------------------- */










    public function render_settings_page() {
        // Process settings submission.
        if ( isset($_POST['tabular3_settings_nonce']) && wp_verify_nonce($_POST['tabular3_settings_nonce'], 'tabular3_save_settings') ) {
            $post_types = $this->get_post_types();
            foreach ($_POST['fields'][$post_type] as $field_key => $settings) {
                $sanitized_settings = [
                    'label' => sanitize_text_field($settings['label']),
                    'input_format' => sanitize_text_field($settings['input_format']),
                ];
            
                // Conditional settings
                if($settings['input_format'] === 'taxonomy_autocomplete') {
                    $sanitized_settings['taxonomy'] = sanitize_key($settings['taxonomy']);
                }
                if($settings['input_format'] === 'select') {
                    $sanitized_settings['select_options'] = sanitize_textarea_field($settings['select_options']);
                }
                if($settings['input_format'] === 'relationship') {
                    $sanitized_settings['relationship_type'] = sanitize_key($settings['relationship_type']);
                }
            
                update_option('tabular3_' . $post_type . '_field_' . sanitize_key($field_key), $sanitized_settings);
            }    
            
            /*
            foreach ( $post_types as $post_type ) {
                $enabled = isset($_POST['tabular3_' . $post_type . '_enabled']) ? 1 : 0;
                update_option('tabular3_' . $post_type . '_enabled', $enabled);

                // Save field settings for enabled post types.
                if ( $enabled && isset($_POST['fields'][$post_type]) && is_array($_POST['fields'][$post_type]) ) {
                    $fields = $_POST['fields'][$post_type];
                    foreach ($_POST['fields'][$post_type] as $field_key => $settings) {
                        $sanitized_settings = [
                            'label' => sanitize_text_field($settings['label']),
                            'input_format' => sanitize_text_field($settings['input_format']),
                        ];
                    
                        // Conditional settings
                        if($settings['input_format'] === 'taxonomy_autocomplete') {
                            $sanitized_settings['taxonomy'] = sanitize_key($settings['taxonomy']);
                        }
                        if($settings['input_format'] === 'select') {
                            $sanitized_settings['select_options'] = sanitize_textarea_field($settings['select_options']);
                        }
                        if($settings['input_format'] === 'relationship') {
                            $sanitized_settings['relationship_type'] = sanitize_key($settings['relationship_type']);
                        }
                    
                        update_option('tabular3_' . $post_type . '_field_' . sanitize_key($field_key), $sanitized_settings);
                    }    

                    // Save the list of fields.
                    update_option('tabular3_' . $post_type . '_fields', array_keys($fields));
                }
            }
            */
            echo '<div class="updated"><p>Settings saved.</p></div>';
        }
        
        $js_inc = '<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js"></script>';
        ?>
        <div class="wrap tabular">
            <h1>Tabular 3 Settings</h1>
            <form method="post" action="">
                <?php wp_nonce_field('tabular3_save_settings', 'tabular3_settings_nonce'); ?>
                <h2>Post Types</h2>
                <table class="form-table">
                    <?php
                    $post_types = $this->get_post_types();
                    foreach ( $post_types as $post_type ) {
                        $enabled = get_option('tabular3_' . $post_type . '_enabled', false);
                        ?>
                        <tr>
                            <th scope="row"><?php echo ucwords(esc_html($post_type)); ?></th>
                            <td>
                                <label>
                                    <input type="checkbox" name="tabular3_<?php echo esc_attr($post_type); ?>_enabled" value="1" <?php checked(1, $enabled, true); ?> />
                                    Enable Tabular for <?php echo esc_html($post_type); ?>
                                </label>
                            </td>
                        </tr>
                        <?php
                        // If enabled, show field settings.
                        if ( $enabled ) {
                            // Get existing field settings.
                            $fields_option = get_option('tabular3_' . $post_type . '_fields', array());
                            $fields = array();
                            foreach ( $fields_option as $field_key ) {
                                $field_settings = get_option('tabular3_' . $post_type . '_field_' . sanitize_key($field_key), array());
                                if ( empty($field_settings) ) {
                                    $field_settings = array(
                                        'display'       => 'yes',
                                        'label'         => $field_key,
                                        'visibility'    => 'edit_view', // Options: edit_view, view, hidden.
                                        'input_format'  => 'text',      // Default input type.
                                    );
                                }
                                $fields[$field_key] = $field_settings;
                            }
                            // Recalculate custom fields from existing posts.
                            $new_fields = $this->get_custom_fields_for_post_type($post_type);
                            foreach ( $new_fields as $new_field ) {
                                if ( ! isset($fields[$new_field]) ) {
                                    $fields[$new_field] = array(
                                        'display'       => 'yes',                                        
                                        'label'         => $new_field,
                                        'visibility'    => 'edit_view',
                                        'input_format'  => 'text'
                                    );
                                }
                            }
                            ?>
                            <tr>
                                <td colspan="2">
                                    <h3>Field Settings for <?php echo esc_html($post_type); ?></h3>
                                    <p>Drag to reorder fields:</p>
                                    <ul id="fields_<?php echo esc_attr($post_type); ?>" class="tabular3-fields-list">
                                        <?php foreach ( $fields as $field_key => $settings ) { ?>
                                        <li class="tabular3-field-item">
                                            <strong><?php echo esc_html($field_key); ?></strong><br/>
                                        
                                            <label><span>Label:</span>
                                                <input type="text" name="fields[<?php echo esc_attr($post_type); ?>][<?php echo esc_attr($field_key); ?>][label]" value="<?php echo esc_attr($settings['label']); ?>" />
                                            </label><br/>
                                        
                                            <label><span>Input Format:</span>
                                                <select class="tabular-input-format" data-field-key="<?php echo esc_attr($field_key); ?>" name="fields[<?php echo esc_attr($post_type); ?>][<?php echo esc_attr($field_key); ?>][input_format]">
                                                    <option value="text" <?php selected($settings['input_format'], 'text'); ?>>Text</option>
                                                    <option value="number" <?php selected($settings['input_format'], 'number'); ?>>Number</option>
                                                    <option value="date" <?php selected($settings['input_format'], 'date'); ?>>Date</option>
                                                    <option value="textarea" <?php selected($settings['input_format'], 'textarea'); ?>>Textarea</option>
                                                    <option value="wysiwyg" <?php selected($settings['input_format'], 'wysiwyg'); ?>>WYSIWYG</option>
                                                    <option value="media_upload" <?php selected($settings['input_format'], 'media_upload'); ?>>Media Upload</option>
                                                    <option value="taxonomy_autocomplete" <?php selected($settings['input_format'], 'taxonomy_autocomplete'); ?>>Taxonomy Autocomplete</option>
                                                    <option value="select" <?php selected($settings['input_format'], 'select'); ?>>Select List</option>
                                                    <option value="relationship" <?php selected($settings['input_format'], 'relationship'); ?>>Relationship</option>
                                                    <option value="readonly" <?php selected($settings['input_format'], 'readonly'); ?>>Read Only</option>
                                                    <option value="hidden" <?php selected($settings['input_format'], 'hidden'); ?>>Hidden</option>
                                                </select>
                                            </label><br/>
                                        
                                            <!-- Conditional Sections -->
                                            <div class="conditional-settings" id="conditional-<?php echo esc_attr($field_key); ?>">
                                                <?php 
                                                // For taxonomy_autocomplete
                                                $taxonomies = get_taxonomies([], 'objects');
                                                ?>
                                                <div class="conditional-section taxonomy_autocomplete" style="display:none;">
                                                    <label>Select Taxonomy for Autocomplete:
                                                        <select name="fields[<?php echo esc_attr($post_type); ?>][<?php echo esc_attr($field_key); ?>][taxonomy]">
                                                            <?php foreach($taxonomies as $tax): ?>
                                                                <option value="<?php echo esc_attr($tax->name); ?>" <?php selected($settings['taxonomy'], $tax->name); ?>>
                                                                    <?php echo esc_html($tax->label); ?>
                                                                </option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </label>
                                                </div>
                                        
                                                <!-- For Select List -->
                                                <div class="conditional-section select" style="display:none;">
                                                    <label>Enter select options (one per line):
                                                        <textarea name="fields[<?php echo esc_attr($post_type); ?>][<?php echo esc_attr($field_key); ?>][select_options]"><?php echo esc_textarea($settings['select_options']); ?></textarea>
                                                    </label>
                                                </div>
                                        
                                                <!-- For Relationship -->
                                                <div class="conditional-section relationship" style="display:none;">
                                                    <label>Select Relationship Type:
                                                        <select name="fields[<?php echo esc_attr($post_type); ?>][<?php echo esc_attr($field_key); ?>][relationship_type]">
                                                            <option value="post_type" <?php selected($settings['relationship_type'], 'post_type'); ?>>Post Type</option>
                                                            <option value="taxonomy" <?php selected($settings['relationship_type'], 'taxonomy'); ?>>Taxonomy</option>
                                                            <option value="user_role" <?php selected($settings['relationship_type'], 'user_role'); ?>>User Role</option>
                                                        </select>
                                                    </label>
                                                </div>
                                            </div>
                                        </li>





                                        <?php } ?>
                                    </ul>
                                    <?php 
                                    echo $js_inc;
                                    $js_inc = ''; 
                                    ?>
                                    <script defer>
                                        jQuery(document).ready(function($){
                                            $("#fields_<?php echo esc_js($post_type); ?>").sortable();
                                        });
                                    </script>
                                </td>
                            </tr>
                        <?php }
                    }
                    ?>
                </table>
                <?php submit_button(); ?>
            </form>
        </div>
        <?php
    }
    
    
    /* ------------------------------------------------- */
    
    
                
                window.tabular3_config = {
                    postType: '<?php echo esc_js($post_type); ?>',
                    editorFields: [
                        <?php
                        $first = true;
                        foreach ( $fields_option as $field_key ) {
                            $field_settings = get_option('tabular3_' . $post_type . '_field_' . sanitize_key($field_key), array());
                            if ( isset($field_settings['visibility']) && $field_settings['visibility'] == 'hidden' ) {
                                continue;
                            }
                            if ( isset($field_settings['display']) && $field_settings['display'] == 'no' ) {
                                continue;
                            }                              
                            if ( ! $first ) {
                                echo ",";
                            }
                            $first = false;
                            ?>
                            {
                                label: "<?php echo esc_js($field_settings['label']); ?>",
                                name: "<?php echo esc_js($field_key); ?>",
                                src: "",
                                inputFormat: "<?php echo esc_js($field_settings['input_format']); ?>"
                            }
                            <?php
                        }
                        ?>
                    ],
                    dtColumns: [
                        <?php
                        $first = true;
                        foreach ( $fields_option as $field_key ) {
                            $field_settings = get_option('tabular3_' . $post_type . '_field_' . sanitize_key($field_key), array());
                            if ( isset($field_settings['visibility']) && $field_settings['visibility'] == 'hidden' ) {
                                continue;
                            }
                            if ( isset($field_settings['display']) && $field_settings['display'] == 'no' ) {
                                continue;
                            }                            
                            if ( ! $first ) {
                                echo ",";
                            }
                            $first = false;
                            ?>
                            {
                                data: "<?php echo esc_js($field_key); ?>",
                                title: "<?php echo esc_js($field_settings['label']); ?>"
                            }
                            <?php
                        }
                        ?>
                    ]
                };   
                
                
    /* ---------------------  */
    
    
    
    public function ummm_enqueue_admin_assets($hook) {
        // Only load on our Tabular pages.
        if ( strpos($hook, 'tabular3') === false && strpos($hook, 'edit.php') === false ) {
            return;
        }
    
        // Use WordPress’ built-in jQuery.
        wp_enqueue_script('jquery');
    
        // Enqueue DataTables Core JS & CSS
        wp_enqueue_script(
            'datatables-js',
            $this->plugin_url . 'assets/datatables/datatables.js',
            array('jquery'),
            '2.2.2',
            true
        );
        wp_enqueue_style(
            'datatables-css',
            $this->plugin_url . 'assets/datatables/datatables.css',
            array(),
            '2.2.2'
        );
            
        wp_enqueue_script(
            'datatables-editor-js',
            $this->plugin_url . 'assets/datatables/js/dataTables.editor.min.js',
            ['datatables-js'],
            '2.2.2',
            true
        );    
    
        // Enqueue Bootstrap JS & CSS from CDN
        wp_enqueue_style(
            'bootstrap-css',
            'https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.2/css/bootstrap.min.css',
            array(),
            '4.5.2'
        );
        wp_enqueue_script(
            'bootstrap-js',
            'https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.2/js/bootstrap.min.js',
            array('jquery'),
            '4.5.2',
            true
        );
    
        /*
        // Enqueue DataTables Bootstrap4 integration JS & CSS
        wp_enqueue_script(
            'datatables-bootstrap4-js',
            'https://cdn.datatables.net/2.2.2/js/dataTables.bootstrap4.min.js',
            array('datatables-js', 'bootstrap-js'),
            '2.2.2',
            true
        );
        wp_enqueue_style(
            'datatables-bootstrap4-css',
            'https://cdn.datatables.net/2.2.2/css/dataTables.bootstrap4.min.css',
            array('bootstrap-css'),
            '2.2.2'
        );
        */
    
        // Editor Bootstrap4 integration files
        wp_enqueue_script(
            'editor-bootstrap4-js',
            $this->plugin_url . 'assets/datatables/js/editor.bootstrap4.min.js',
            array('datatables-js', 'bootstrap-js'),
            '1.0',
            true
        );
        wp_enqueue_style(
            'editor-bootstrap4-css',
            $this->plugin_url . 'assets/datatables/css/editor.bootstrap4.min.css',
            array('bootstrap-css'),
            '1.0'
        );
    
        wp_enqueue_editor();    
    
        // Enqueue custom admin JS & CSS
        wp_enqueue_script(
            'tabular3-admin',
            $this->plugin_url . 'assets/js/tabular3-admin.js',
            array('jquery', 'datatables-js', 'editor-bootstrap4-js'),
            '1.0',
            true
        );
        wp_enqueue_style(
            'tabular3-admin-css',
            $this->plugin_url . 'assets/css/tabular3-admin.css',
            array(),
            '1.0'
        );
    
        // Localize AJAX variables
        wp_localize_script('tabular3-admin', 'tabular3', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce'    => wp_create_nonce('tabular3_nonce')
        ));
    
        // For draggable fields (settings page only)
        if (isset($_GET['page']) && $_GET['page'] === 'tabular3-settings') {
            wp_enqueue_style(
                'jquery-ui-css',
                'https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css'
            );
            wp_enqueue_script('jquery-ui-sortable');
            
            // Enqueue your custom Tabular3 admin JavaScript.
            wp_enqueue_script(
                'tabular3-settings-admin',
                $this->plugin_url . 'assets/js/tabular3-settings.js',
                array(
                    'jquery'
                ),
                '1.0',
                true
            );
        }
    }
    
    
/* ----------------------- */

    public function enqueue_admin_assets($hook) {
        if (strpos($hook, 'tabular3') === false && strpos($hook, 'edit.php') === false) {
            return;
        }
    
        wp_enqueue_script('jquery');
    
        // Ensure WordPress TinyMCE Editor is available
        wp_enqueue_editor();
    
        // DataTables 2.x
        wp_enqueue_script(
            'datatables-js',
            $this->plugin_url . 'assets/datatables/datatables.js',
            ['jquery'],
            '2.2.2',
            true
        );
        wp_enqueue_style(
            'datatables-css',
            $this->plugin_url . 'assets/datatables/datatables.css',
            [],
            '2.2.2'
        );
    
        // DataTables Editor 2.x
        wp_enqueue_script(
            'datatables-editor-js',
            $this->plugin_url . 'assets/datatables/js/dataTables.editor.min.js',
            ['datatables-js'],
            '2.2.2',
            true
        );
    
        // Bootstrap 4 Integration for DataTables
        wp_enqueue_script(
            'editor-bootstrap4-js',
            $this->plugin_url . 'assets/datatables/js/editor.bootstrap4.min.js',
            ['datatables-editor-js'],
            '2.2.2',
            true
        );
    
        // Custom Admin JavaScript
        wp_enqueue_script(
            'tabular3-admin',
            $this->plugin_url . 'assets/js/tabular3-admin.js',
            ['jquery', 'datatables-js', 'datatables-editor-js', 'editor-bootstrap4-js'],
            '1.0',
            true
        );
    
        // Localize script for AJAX
        wp_localize_script('tabular3-admin', 'tabular3', [
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce'    => wp_create_nonce('tabular3_nonce')
        ]);
    }


/* -------------------------- */


     
     
    public function umm...ajax_update_posts() {
        if ( ! isset($_POST['nonce']) || ! wp_verify_nonce($_POST['nonce'], 'tabular3_nonce') ) {
            wp_send_json_error('Invalid nonce');
        }
        $post_type = isset($_POST['post_type']) ? sanitize_key($_POST['post_type']) : 'post';
        $data      = isset($_POST['data']) ? $_POST['data'] : array();

        $results = array();

        foreach ( $data as $post_id => $fields ) {
            $post_id = intval($post_id);
            $updated_fields = array();
            foreach ( $fields as $key => $value ) {
                /*
                if ( $key === 'ID' ) {
                    continue;
                }
                */
                
                // Update each field as post meta.
                $updated = update_post_meta( $post_id, sanitize_key($key), sanitize_text_field($value) );
                $updated_fields[$key] = $updated;
            }
            // Optionally, update post title or content if edited.
            $results[$post_id] = $updated_fields;
        }

        wp_send_json_success($results);
    }
    
    
/* ----------------- */



     
    public function ajax_update_posts() {
        if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'tabular3_nonce')) {
            wp_send_json_error('Invalid nonce');
        }
    
        $post_type = isset($_POST['post_type']) ? sanitize_key($_POST['post_type']) : 'post';
        $data      = isset($_POST['data']) ? $_POST['data'] : array();
    
        $results = array();
    
        foreach ($data as $post_id => $fields) {
            $post_id = intval($post_id);
            $updated_fields = array();
            $post_updates = array('ID' => $post_id);
            $meta_updates = array();
            $taxonomy_updates = array();
    
            foreach ($fields as $key => $value) {
                // Identify whether it's a post field, taxonomy, or custom field.
                if (in_array($key, ['post_title', 'post_content', 'post_status', 'post_date'])) {
                    // ✅ Update Core Post Fields
                    $post_updates[$key] = sanitize_text_field($value);
                } elseif (taxonomy_exists($key)) {
                    // ✅ Update Taxonomy Terms (Convert comma-separated string to array)
                    $taxonomy_updates[$key] = array_map('sanitize_text_field', explode(',', $value));
                } else {
                    // ✅ Update Custom Fields (Meta Fields)
                    $meta_updates[$key] = sanitize_text_field($value);
                }
            }
    
            // ✅ If any post fields need updating, update via `wp_update_post`
            if (count($post_updates) > 1) { // Ignore if only 'ID' exists
                $update_post_result = wp_update_post($post_updates, true);
                if (is_wp_error($update_post_result)) {
                    $results[$post_id]['post_error'] = $update_post_result->get_error_message();
                } else {
                    $results[$post_id]['post_updated'] = $update_post_result;
                }
            }
    
            // ✅ If any taxonomies need updating, update them
            foreach ($taxonomy_updates as $taxonomy => $terms) {
                $update_terms_result = wp_set_object_terms($post_id, $terms, $taxonomy);
                if (is_wp_error($update_terms_result)) {
                    $results[$post_id]['taxonomy_error'][$taxonomy] = $update_terms_result->get_error_message();
                } else {
                    $results[$post_id]['taxonomy_updated'][$taxonomy] = $update_terms_result;
                }
            }
    
            // ✅ If any custom fields need updating, update via `update_post_meta`
            foreach ($meta_updates as $meta_key => $meta_value) {
                $updated = update_post_meta($post_id, sanitize_key($meta_key), $meta_value);
                $results[$post_id]['meta_updated'][$meta_key] = $updated;
            }
        }
    
        wp_send_json_success($results);
    }
    
    
/* -------------------------------- */


    public function unused_ajax_update_posts() {
        if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'tabular3_nonce')) {
            wp_send_json_error('Invalid nonce');
        }
    
        $post_type = isset($_POST['post_type']) ? sanitize_key($_POST['post_type']) : 'post';
        $data = isset($_POST['data']) ? $_POST['data'] : [];
    
        $results = [];
    
        foreach ($data as $post_id => $fields) {
            $post_id = intval($post_id);
            $updated_fields = [];
            $post_updates = ['ID' => $post_id];
            $meta_updates = [];
            $taxonomy_updates = [];
    
            foreach ($fields as $key => $value) {
                if ($key === 'post_title' || $key === 'post_content' || $key === 'post_status' || $key === 'post_date') {
                    $post_updates[$key] = sanitize_text_field($value);
                } elseif (taxonomy_exists($key)) {
                    $taxonomy_updates[$key] = array_map('sanitize_text_field', explode(',', $value));
                } elseif ($key === 'featured_image') {
                    $mediaData = json_decode($value, true);
                    if (!empty($mediaData) && isset($mediaData[0]['id'])) {
                        set_post_thumbnail($post_id, $mediaData[0]['id']);
                    }
                } else {
                    $mediaData = json_decode($value, true);
                    if (!empty($mediaData)) {
                        $imgHtml = '<ul>';
                        foreach ($mediaData as $media) {
                            $imgHtml .= '<li><img src="' . esc_url($media['url']) . '" data-id="' . intval($media['id']) . '"></li>';
                        }
                        $imgHtml .= '</ul>';
                        $meta_updates[$key] = $imgHtml;
                    } else {
                        $meta_updates[$key] = sanitize_text_field($value);
                    }
                }
            }
    
            if (count($post_updates) > 1) {
                wp_update_post($post_updates);
            }
    
            foreach ($taxonomy_updates as $taxonomy => $terms) {
                wp_set_object_terms($post_id, $terms, $taxonomy);
            }
    
            foreach ($meta_updates as $meta_key => $meta_value) {
                update_post_meta($post_id, $meta_key, $meta_value);
            }
    
            $results[$post_id] = $updated_fields;
        }
    
        wp_send_json_success($results);
    }