jQuery(document).ready(function($) {
    
    // DataTable.use('bootstrap');

    // Check if our configuration object exists.
    if (typeof window.tabular3_config === 'undefined') {
        console.error('Tabular3 configuration is missing.');
        return;
    }
    
    const config = window.tabular3_config;
    
    // Initialize the integrated DataTable Editor instance.
    const editor = new DataTable.Editor({
        ajax: {
            url: tabular3.ajax_url,
            type: 'POST',
            data: function(d) {
                d.action = 'tabular3_update_posts';
                d.nonce = tabular3.nonce;
                d.post_type = config.postType;
            },
            create: {
                type: 'POST',
                url: tabular3.ajax_url,
                data: { action: "postDBDoCreate", postType: config.postType }
            },
            edit: {
                type: 'POST',
                url: tabular3.ajax_url,
                data: { action: "postDBDoEditor", postType: config.postType }
            },
            remove: {
                type: 'POST',
                url: tabular3.ajax_url,
                data: { action: "postDBDoRemove", postType: config.postType }
            }            
        },
        fields: config.editorFields,
        idSrc: 'ID',
        table: '#tabular3-table',
        display: 'bootstrap4',
        colReorder: true
    });
    
    // Our custom field type
    $.fn.dataTable.Editor.fieldTypes.currency = $.extend(true, {}, $.fn.dataTable.Editor.models.fieldType, {
        "create": function (conf) {
            // Create the elements to use for the input
            conf._input = $(
                '<div>' +
                '<input type="text" class="editor-currency" id="' + conf.id + '" required pattern="[0-9,{1,8}]\.[0-9{2}]"/>' +
                '</div>')[0];

            return conf._input;
        },

        "get": function (conf) {
            return conf._input.childNodes[0].value;
        },

        "set": function (conf, val) {
            conf._input.childNodes[0].value = val;
        }
    });
    $.fn.dataTable.Editor.fieldTypes.number = $.extend(true, {}, $.fn.dataTable.Editor.models.fieldType, {
        "create": function (conf) {
            // Create the elements to use for the input
            conf._input = $(
                '<div>' +
                '<input type="number" class="editor-number" id="' + conf.id + '" required pattern="[0-9,{1,8}]\.[0-9{2}]"/>' +
                '</div>')[0];

            return conf._input;
        },

        "get": function (conf) {
            return conf._input.childNodes[0].value;
        },

        "set": function (conf, val) {
            conf._input.childNodes[0].value = val;
        }
    });

    
    // Initialize the DataTable.
    new DataTable('#tabular3-table', {
        dom: 'Bfrtip',
        display: 'bootstrap4',
        ajax: {
            url: tabular3.ajax_url,
            type: 'POST',
            data: {
                action: 'tabular3_get_posts',
                nonce: tabular3.nonce,
                post_type: config.postType
            }
        },
        columns: config.dtColumns,
        layout: {
            topStart: {
                buttons: [
                    { extend: 'create', editor: editor },
                    { extend: 'edit',   editor: editor },
                    { extend: 'remove', editor: editor }
                ]
            }
        },
        responsive: true,
        autoWidth: true,
        colReorder: true,
        select: true,
        serverSide: true,
        processing: true,
        paging: true
    });

    
    
});
