// tabular3-media-extensions.js
(function($) {
    // WordPress Media Upload Extension
    const TabularMediaExtensions = {
        // Global media frame variable
        current_input: null,

        // Initialize media upload event handlers
        init: function() {
            // Add media upload button next to text inputs
            $(document).on('init.dt.dtedit', function(e, settings, editor) {
                editor.on('open', function() {
                    // Find all text inputs that might benefit from media upload
                    $('.DTE_Field_Input input[type="text"]').each(function() {
                        const $input = $(this);
                        
                        // Check if media upload button already exists
                        if ($input.next('.media-upload-trigger').length === 0) {
                            $('<button>', {
                                type: 'button',
                                class: 'button media-upload-trigger',
                                text: 'Media Library',
                                click: function(e) {
                                    e.preventDefault();
                                    TabularMediaExtensions.openMediaUploader($input);
                                }
                            }).insertAfter($input);
                        }
                    });
                });
            });
        },

        // Open media uploader
        openMediaUploader: function($input) {
            this.current_input = $input;

            // If the media frame already exists, reopen it
            if (this.mediaFrame) {
                this.mediaFrame.open();
                return;
            }

            // Create the media frame
            this.mediaFrame = wp.media({
                title: 'Select or Upload Media',
                button: {
                    text: 'Use this media'
                },
                multiple: false  // Set to true if you want multiple selection
            });

            // When a file is selected, grab the URL and set it as the text input's value
            this.mediaFrame.on('select', function() {
                // Get selected attachment
                const attachment = TabularMediaExtensions.mediaFrame.state().get('selection').first().toJSON();
                
                // Provide options for what to insert
                const choice = prompt('Select what to insert:', [
                    'URL', 
                    'Attachment ID', 
                    'Title', 
                    'Filename'
                ]);

                let valueToInsert;
                switch(choice) {
                    case 'Attachment ID':
                        valueToInsert = attachment.id;
                        break;
                    case 'Title':
                        valueToInsert = attachment.title;
                        break;
                    case 'Filename':
                        valueToInsert = attachment.filename;
                        break;
                    default:
                        valueToInsert = attachment.url;
                }

                // Set the input value
                TabularMediaExtensions.current_input.val(valueToInsert);
            });

            // Open the media frame
            this.mediaFrame.open();
        }
    };

    // Initialize on document ready
    $(document).ready(function() {
        TabularMediaExtensions.init();
    });

})(jQuery);