(function() {
    // Ensure Tabular3 namespace exists and has the extension method
    if (window.Tabular3 && window.Tabular3.extendInputFormatMapping) {
        // Add example custom field types
        window.Tabular3.extendInputFormatMapping({
            // Example of a star rating field
            'star_rating': { 
                type: 'star_rating',
                create: function(conf) {
                    // Create a star rating input
                    conf._input = $(`
                        <div class="star-rating-wrapper">
                            <input type="hidden" class="star-rating-input" id="${conf.id}" name="${conf.name}">
                            <div class="star-rating-display">
                                ${[1,2,3,4,5].map(star => `
                                    <span class="star" data-rating="${star}">★</span>
                                `).join('')}
                            </div>
                        </div>
                    `)[0];

                    // Add click event to stars
                    $(conf._input).find('.star').on('click', function() {
                        const rating = $(this).data('rating');
                        $(conf._input).find('.star').removeClass('selected');
                        $(this).prevAll('.star').addBack().addClass('selected');
                        $(conf._input).find('.star-rating-input').val(rating);
                    });
                    
                    return conf._input;
                },
                get: function(conf) {
                    return $(conf._input).find('.star-rating-input').val();
                },
                set: function(conf, val) {
                    const $wrapper = $(conf._input);
                    $wrapper.find('.star-rating-input').val(val);
                    
                    // Update visual display
                    $wrapper.find('.star').removeClass('selected');
                    $wrapper.find(`.star[data-rating="${val}"]`)
                        .prevAll('.star')
                        .addBack()
                        .addClass('selected');
                }
            },

            // Example of a color picker field
            'color_picker': {
                type: 'color_picker',
                create: function(conf) {
                    conf._input = $(`
                        <div class="color-picker-wrapper">
                            <input type="text" class="color-picker-input" id="${conf.id}" name="${conf.name}">
                            <input type="color" class="color-picker-visual">
                        </div>
                    `)[0];

                    // Sync text and color inputs
                    $(conf._input).find('.color-picker-input, .color-picker-visual').on('input', function() {
                        const $wrapper = $(this).closest('.color-picker-wrapper');
                        const textInput = $wrapper.find('.color-picker-input');
                        const colorInput = $wrapper.find('.color-picker-visual');
                        
                        // Ensure inputs are in sync
                        if (this.type === 'text') {
                            colorInput.val(textInput.val());
                        } else {
                            textInput.val(colorInput.val());
                        }
                    });
                    
                    return conf._input;
                },
                get: function(conf) {
                    return $(conf._input).find('.color-picker-input').val();
                },
                set: function(conf, val) {
                    const $wrapper = $(conf._input);
                    $wrapper.find('.color-picker-input, .color-picker-visual').val(val);
                }
            }
        });

        // Add some CSS for the custom field types
        const style = document.createElement('style');
        style.textContent = `
            .star-rating-display .star {
                cursor: pointer;
                color: #ddd;
                font-size: 1.5em;
            }
            .star-rating-display .star.selected {
                color: gold;
            }
            .color-picker-wrapper {
                display: flex;
                align-items: center;
            }
            .color-picker-input {
                margin-right: 10px;
                flex-grow: 1;
            }
        `;
        document.head.appendChild(style);
    }
})();