/**
 * Quick Contact Buttons - Frontend JavaScript
 */

(function($) {
    'use strict';
    
    $(document).ready(function() {
        const $container = $('#qcb-container');
        const $toggleBtn = $('#qcb-toggle');
        let scrollThreshold = 200; // Show after scrolling 200px
        let isCollapsed = false;
        
        if (!$container.length) {
            return;
        }
        
        /**
         * Handle scroll events to show/hide the container
         */
        function handleScroll() {
            const scrollTop = $(window).scrollTop();
            
            if (scrollTop > scrollThreshold) {
                $container.removeClass('qcb-hidden').addClass('qcb-visible');
            } else {
                $container.removeClass('qcb-visible').addClass('qcb-hidden');
                // Reset collapsed state when hidden
                if (isCollapsed) {
                    $container.removeClass('qcb-collapsed');
                    isCollapsed = false;
                }
            }
        }
        
        /**
         * Toggle collapsed/expanded state
         */
        function toggleButtons(e) {
            e.preventDefault();
            e.stopPropagation();
            
            if (isCollapsed) {
                // Expand
                $container.removeClass('qcb-collapsed');
                isCollapsed = false;
            } else {
                // Collapse
                $container.addClass('qcb-collapsed');
                isCollapsed = true;
            }
        }
        
        /**
         * Initialize scroll listener with debouncing
         */
        let scrollTimeout;
        $(window).on('scroll', function() {
            if (scrollTimeout) {
                clearTimeout(scrollTimeout);
            }
            scrollTimeout = setTimeout(handleScroll, 10);
        });
        
        /**
         * Toggle button click handler
         */
        $toggleBtn.on('click', toggleButtons);
        
        /**
         * Initialize on page load
         */
        handleScroll();
        
        /**
         * Save collapsed state in session storage (optional)
         */
        // Check if user had previously collapsed it
        if (sessionStorage.getItem('qcbCollapsed') === 'true') {
            $container.addClass('qcb-collapsed');
            isCollapsed = true;
        }
        
        // Save state when toggled
        $toggleBtn.on('click', function() {
            if (isCollapsed) {
                sessionStorage.setItem('qcbCollapsed', 'true');
            } else {
                sessionStorage.removeItem('qcbCollapsed');
            }
        });
    });
    
})(jQuery);
