<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <?php settings_errors(); ?>
    
    <form method="post" action="options.php">
        <?php
        settings_fields('qcb_settings_group');
        do_settings_sections('qcb_settings_group');
        ?>
        
        <table class="form-table" role="presentation">
            <tbody>
                <tr>
                    <th scope="row">
                        <label for="qcb_phone_number">Phone Number</label>
                    </th>
                    <td>
                        <input 
                            type="text" 
                            id="qcb_phone_number" 
                            name="qcb_phone_number" 
                            value="<?php echo esc_attr(get_option('qcb_phone_number', '')); ?>" 
                            class="regular-text"
                            placeholder="+1-250-555-0123"
                        />
                        <p class="description">Phone number for the call button (format: +1-250-555-0123)</p>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row">
                        <label for="qcb_sms_number">SMS Number</label>
                    </th>
                    <td>
                        <input 
                            type="text" 
                            id="qcb_sms_number" 
                            name="qcb_sms_number" 
                            value="<?php echo esc_attr(get_option('qcb_sms_number', '')); ?>" 
                            class="regular-text"
                            placeholder="+1-250-555-0123"
                        />
                        <p class="description">SMS number for the text message button (format: +1-250-555-0123)</p>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row">
                        <label for="qcb_email">Email Address</label>
                    </th>
                    <td>
                        <input 
                            type="email" 
                            id="qcb_email" 
                            name="qcb_email" 
                            value="<?php echo esc_attr(get_option('qcb_email', '')); ?>" 
                            class="regular-text"
                            placeholder="contact@example.com"
                        />
                        <p class="description">Email address for the email button</p>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row">
                        <label for="qcb_bg_color">Background Color</label>
                    </th>
                    <td>
                        <input 
                            type="text" 
                            id="qcb_bg_color" 
                            name="qcb_bg_color" 
                            value="<?php echo esc_attr(get_option('qcb_bg_color', '#0073aa')); ?>" 
                            class="qcb-color-picker"
                        />
                        <p class="description">Background color for the contact buttons</p>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row">
                        <label for="qcb_fg_color">Text/Icon Color</label>
                    </th>
                    <td>
                        <input 
                            type="text" 
                            id="qcb_fg_color" 
                            name="qcb_fg_color" 
                            value="<?php echo esc_attr(get_option('qcb_fg_color', '#ffffff')); ?>" 
                            class="qcb-color-picker"
                        />
                        <p class="description">Foreground color for icons and text</p>
                    </td>
                </tr>
            </tbody>
        </table>
        
        <?php submit_button('Save Settings'); ?>
    </form>
    
    <hr>
    
    <h2>Preview</h2>
    <p>The contact buttons will appear on the right side of your website after visitors scroll down the page. Buttons will only show for contact methods you've entered above.</p>
    
    <div style="margin-top: 20px; padding: 15px; background: #f0f0f1; border-radius: 4px;">
        <strong>Note:</strong> Make sure to enter at least one contact method for the buttons to appear on your site.
    </div>
</div>
