# Quick Contact Buttons - WordPress Plugin

A lightweight WordPress plugin that adds quick access contact buttons (phone, SMS, email) to the right side of your website. The buttons appear after the user scrolls down and can be collapsed/expanded with a toggle button.

## Features

- **Three contact methods**: Phone, SMS, and Email
- **Customizable colors**: Set background and foreground colors to match your brand
- **Scroll-activated**: Buttons appear only after user starts scrolling (200px threshold)
- **Collapsible**: X button collapses buttons to just a + icon
- **High z-index**: Always visible above other content
- **Mobile responsive**: Adapts to different screen sizes
- **Remembers state**: Collapsed state persists during the session

## Installation

1. Upload the `quick-contact-buttons` folder to `/wp-content/plugins/`
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Go to Settings > Contact Buttons to configure

## Configuration

Navigate to **Settings > Contact Buttons** in your WordPress admin panel.

### Settings:

1. **Phone Number** - Enter your phone number (e.g., +1-250-555-0123)
   - Creates a `tel:` link when clicked
   
2. **SMS Number** - Enter your SMS number (e.g., +1-250-555-0123)
   - Creates an `sms:` link when clicked
   
3. **Email Address** - Enter your email address
   - Creates a `mailto:` link when clicked
   
4. **Background Color** - Choose the background color for buttons
   - Default: #0073aa (WordPress blue)
   
5. **Text/Icon Color** - Choose the foreground color for icons
   - Default: #ffffff (white)

**Note**: At least one contact method must be entered for the buttons to appear on your site.

## Usage

Once configured, the buttons will automatically appear on the frontend:

- **Position**: Fixed to the right side, positioned in the bottom 60-80% of the screen
- **Visibility**: Hidden initially, appears after scrolling down 200px
- **Toggle**: Click the X button to collapse buttons (shows only +)
- **Expand**: Click the + button to expand buttons again
- **Contact**: Click any button to initiate phone call, SMS, or email

## Technical Details

- **PHP Version**: 8.x compatible
- **Dependencies**: jQuery (included with WordPress)
- **Browser Compatibility**: All modern browsers
- **Mobile Friendly**: Responsive design with touch-optimized buttons

## File Structure

```
quick-contact-buttons/
├── quick-contact-buttons.php     # Main plugin file
├── admin/
│   └── settings-page.php         # Admin settings template
├── assets/
│   ├── css/
│   │   ├── admin.css            # Admin styles
│   │   └── frontend.css         # Frontend styles
│   └── js/
│       └── frontend.js          # Frontend JavaScript
└── README.md                     # This file
```

## Customization

### Changing the Scroll Threshold

Edit `assets/js/frontend.js` and modify the `scrollThreshold` variable:

```javascript
let scrollThreshold = 200; // Change this value (in pixels)
```

### Adjusting Position

Edit `assets/css/frontend.css` and modify the `#qcb-container` styles:

```css
#qcb-container {
    right: 20px;    /* Distance from right edge */
    bottom: 40%;    /* Position from bottom (40% = lower portion of screen) */
}
```

### Custom Colors via CSS

While colors can be set in the admin panel, you can also override them with custom CSS:

```css
#qcb-container {
    --qcb-bg-color: #your-color-here;
    --qcb-fg-color: #your-color-here;
}
```

## Support

For support or feature requests, contact Web321 Marketing Ltd.

## License

GPL v2 or later

## Changelog

### Version 1.0.0
- Initial release
- Phone, SMS, and Email button support
- Customizable colors
- Scroll-activated display
- Collapse/expand functionality
- Session state persistence
- Mobile responsive design

## Credits

Developed by Web321 Marketing Ltd.
- Website: https://web321.ca
