<?php
/**
 * Gallery Template - Vertical Filmstrip
 *
 * @package NGVF_Standalone
 * 
 * Available variables:
 * $unique_id - Unique gallery ID
 * $paginated_images - Current page images
 * $atts - Shortcode attributes
 * $current_page - Current page number
 * $total_pages - Total pages
 * $total_images - Total images
 */

if (!defined('ABSPATH')) {
    exit;
}

$columns = intval($atts['columns']);
$thumb_width = intval($atts['thumb_width']);
$thumb_height = intval($atts['thumb_height']);
$enable_lightbox = ($atts['lightbox'] === 'true');
$show_pagination = ($atts['pagination'] === 'true');

$first_image = !empty($paginated_images) ? $paginated_images[0] : null;
?>

<div id="<?php echo esc_attr($unique_id); ?>" class="ngvf-standalone-gallery" data-columns="<?php echo esc_attr($columns); ?>">
    
    <div class="ngvf-container">
        
        <!-- Thumbnails (Left Side) -->
        <div class="ngvf-thumbnails" data-columns="<?php echo esc_attr($columns); ?>">
            <div class="ngvf-thumb-grid">
                <?php foreach ($paginated_images as $index => $image): ?>
                    <?php
                    $active_class = ($index === 0) ? 'active' : '';
                    $alt_text = !empty($image->alttext) ? esc_attr($image->alttext) : esc_attr($image->filename);
                    $title = !empty($image->description) ? esc_attr($image->description) : '';
                    ?>
                    
                    <div class="ngvf-thumb <?php echo esc_attr($active_class); ?>" 
                         data-index="<?php echo esc_attr($index); ?>"
                         data-full="<?php echo esc_url($image->full_url); ?>"
                         data-image="<?php echo esc_url($image->image_url); ?>"
                         data-title="<?php echo esc_attr($title); ?>"
                         data-alt="<?php echo esc_attr($alt_text); ?>"
                         tabindex="0">
                        <img src="<?php echo esc_url($image->thumb_url); ?>" 
                             alt="<?php echo esc_attr($alt_text); ?>"
                             loading="lazy" />
                    </div>
                    
                <?php endforeach; ?>
            </div>
        </div>
        
        <!-- Main Image (Right Side) -->
        <div class="ngvf-main">
            <?php if ($first_image): ?>
                <?php
                $alt_text = !empty($first_image->alttext) ? esc_attr($first_image->alttext) : esc_attr($first_image->filename);
                $title = !empty($first_image->description) ? esc_html($first_image->description) : '';
                ?>
                
                <div class="ngvf-main-wrapper">
                    <?php if ($enable_lightbox): ?>
                        <a href="<?php echo esc_url($first_image->full_url); ?>" 
                           class="ngvf-main-link"
                           data-lightbox="ngvf-<?php echo esc_attr($unique_id); ?>"
                           title="<?php echo esc_attr($title); ?>">
                            <img src="<?php echo esc_url($first_image->image_url); ?>" 
                                 alt="<?php echo esc_attr($alt_text); ?>"
                                 class="ngvf-main-img"
                                 id="<?php echo esc_attr($unique_id); ?>-main" />
                            <span class="ngvf-zoom-icon">🔍</span>
                        </a>
                    <?php else: ?>
                        <img src="<?php echo esc_url($first_image->image_url); ?>" 
                             alt="<?php echo esc_attr($alt_text); ?>"
                             class="ngvf-main-img"
                             id="<?php echo esc_attr($unique_id); ?>-main" />
                    <?php endif; ?>
                </div>
                
                <?php if ($title): ?>
                    <div class="ngvf-info">
                        <p class="ngvf-description"><?php echo esc_html($title); ?></p>
                    </div>
                <?php endif; ?>
                
            <?php endif; ?>
        </div>
        
    </div>
    
    <!-- Pagination -->
    <?php if ($show_pagination && $total_pages > 1): ?>
        <div class="ngvf-pagination">
            <?php
            $base_url = remove_query_arg('ngvf_page');
            
            // Previous
            if ($current_page > 1):
                $prev_url = add_query_arg('ngvf_page', $current_page - 1, $base_url);
                echo '<a href="' . esc_url($prev_url) . '" class="ngvf-prev">&laquo; Previous</a>';
            endif;
            
            // Page info
            echo '<span class="ngvf-page-info">Page ' . $current_page . ' of ' . $total_pages . '</span>';
            
            // Next
            if ($current_page < $total_pages):
                $next_url = add_query_arg('ngvf_page', $current_page + 1, $base_url);
                echo '<a href="' . esc_url($next_url) . '" class="ngvf-next">Next &raquo;</a>';
            endif;
            ?>
        </div>
    <?php endif; ?>
    
</div>
