# NextGen Vertical Filmstrip (Standalone)

**A reliable, standalone gallery plugin that uses NextGen Gallery's images without depending on NextGen's buggy display type system.**

## Why This Version?

NextGen Gallery's display type registration system has SQL bugs that prevent custom display types from working reliably. This standalone version:

✅ **Works directly with NextGen Gallery data** - Uses your existing galleries  
✅ **Bypasses broken registration** - No dependency on NextGen's display type system  
✅ **Simple shortcode** - Easy to use: `[ngvf_gallery id="1"]`  
✅ **More reliable** - Won't break when NextGen Gallery has issues  
✅ **Same great layout** - Vertical filmstrip with thumbnails on left  

## Requirements

- WordPress 5.0+
- NextGen Gallery (any version with galleries/images)
- PHP 7.4+

## Installation

### Quick Install

1. Upload `ngvf-standalone.zip` via **Plugins → Add New → Upload Plugin**
2. Activate the plugin
3. Use the shortcode on any page: `[ngvf_gallery id="1"]`

### Manual Install

1. Extract the zip file
2. Upload the `ngvf-standalone` folder to `/wp-content/plugins/`
3. Activate via **Plugins** menu
4. Use the shortcode

## Usage

### Basic Shortcode

```
[ngvf_gallery id="1"]
```

Replace `1` with your NextGen Gallery ID. Find your gallery ID in **Gallery → Manage Galleries**.

### With Options

```
[ngvf_gallery id="1" columns="3" per_page="20" lightbox="true"]
```

### All Available Options

| Attribute | Default | Description |
|-----------|---------|-------------|
| `id` | Required | NextGen Gallery ID |
| `columns` | 3 | Thumbnail columns (1-4) |
| `per_page` | 20 | Images per page |
| `thumb_width` | 150 | Thumbnail width in pixels |
| `thumb_height` | 150 | Thumbnail height in pixels |
| `lightbox` | true | Enable lightbox on main image |
| `pagination` | true | Show pagination controls |

## Examples

### 2 Column Layout
```
[ngvf_gallery id="5" columns="2"]
```

### 4 Columns with More Images
```
[ngvf_gallery id="3" columns="4" per_page="40"]
```

### Larger Thumbnails
```
[ngvf_gallery id="2" columns="3" thumb_width="200" thumb_height="200"]
```

### No Lightbox
```
[ngvf_gallery id="8" lightbox="false"]
```

### No Pagination
```
[ngvf_gallery id="4" per_page="100" pagination="false"]
```

## Settings Page

Access the settings page at **Settings → NGVF Gallery** in WordPress admin.

### Default Settings

Set default values that apply to all galleries (unless overridden in shortcode):

- **Default Columns** - Number of thumbnail columns (1-4)
- **Default Images Per Page** - Images to show per page
- **Default Thumbnail Width** - Thumbnail width in pixels
- **Default Thumbnail Height** - Thumbnail height in pixels  
- **Enable Lightbox by Default** - Turn lightbox on/off globally
- **Enable Pagination by Default** - Turn pagination on/off globally

### How Defaults Work

1. Set defaults in the settings page
2. Use shortcode without attributes: `[ngvf_gallery id="1"]`
3. Gallery uses your default settings
4. Override per gallery: `[ngvf_gallery id="1" columns="4"]`

### Example Workflow

1. Go to **Settings → NGVF Gallery**
2. Set "Default Columns" to 3
3. Set "Default Images Per Page" to 20
4. Enable lightbox and pagination
5. Use simple shortcode everywhere: `[ngvf_gallery id="1"]`
6. All galleries use your defaults!

## Plugin Page Links

From the **Plugins** page, you can:

- ♥ **Donate** - Support plugin development via PayPal
- **Settings** - Quick link to settings page
- **Documentation** - View full documentation
- **Support** - Get help and support

## How It Works

This plugin:

1. **Reads NextGen Gallery data directly** from the database
2. **Uses NextGen's storage system** to get image URLs
3. **Renders independently** without using NextGen's display type system
4. **Provides same layout** as the original vertical filmstrip

## Finding Your Gallery ID

1. Go to **Gallery → Manage Galleries** in WordPress admin
2. Look at the list of galleries
3. The number in the left column is your Gallery ID
4. Use that number in your shortcode: `[ngvf_gallery id="YOUR_ID"]`

## Features

- ✅ Vertical filmstrip layout
- ✅ Thumbnails on left (1-4 columns)
- ✅ Main image on right
- ✅ Click thumbnails to update main image
- ✅ Lightbox support
- ✅ Pagination for large galleries
- ✅ Keyboard navigation (arrow keys)
- ✅ Fully responsive
- ✅ Touch-friendly
- ✅ Print-optimized

## Customization

### Custom CSS

Add to your theme's CSS:

```css
/* Change active thumbnail border */
.ngvf-thumb.active {
    border-color: #your-color;
}

/* Adjust main image shadow */
.ngvf-main-wrapper {
    box-shadow: your-shadow;
}

/* Change pagination button color */
.ngvf-pagination a {
    background: #your-color;
}
```

### Template Override

To customize the template:

1. Copy `templates/gallery.php` from the plugin
2. Place it in your theme: `your-theme/ngvf-standalone/gallery.php`
3. Edit as needed
4. The plugin will use your custom template

## Troubleshooting

### Gallery Not Showing

**Check Gallery ID:**
- Verify the ID exists in **Gallery → Manage Galleries**
- Make sure the gallery has images

**Clear Cache:**
- Clear WordPress cache
- Clear browser cache
- Clear any CDN cache

### Images Not Loading

**Check NextGen Gallery:**
- Make sure NextGen Gallery is activated
- Verify images exist in the gallery
- Try regenerating thumbnails in NextGen

**Check Image Paths:**
- NextGen Gallery uses `/wp-content/uploads/` for images
- Make sure file permissions are correct (755 for directories, 644 for files)

### Styling Issues

**Clear Caches:**
- Browser cache (Ctrl+Shift+R)
- WordPress cache plugin
- Any CDN cache

**Check for Conflicts:**
- Try default WordPress theme
- Disable other plugins temporarily

## Advantages Over Original Plugin

| Feature | Original | Standalone |
|---------|----------|------------|
| Relies on NextGen display types | Yes | No |
| Affected by NextGen SQL bugs | Yes | No |
| Simple shortcode | No | Yes |
| Direct database access | No | Yes |
| Independent rendering | No | Yes |
| Works with any NextGen version | Sometimes | Always |

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Mobile browsers

## Performance

- **Lightweight** - Minimal code, fast loading
- **Efficient** - Direct database queries
- **Cached** - Works with WordPress caching
- **Optimized** - Lazy loading images

## Support

For issues or questions:
- Check this README
- Visit: https://shawndewolfe.com

## Changelog

### 2.0.0 (2025-10-28)
- Complete rewrite as standalone plugin
- Direct NextGen Gallery database integration
- Bypasses NextGen display type system
- New simple shortcode: `[ngvf_gallery]`
- More reliable and maintainable
- Better error handling
- Improved performance

### 1.0.x
- Original version using NextGen display types
- Deprecated due to NextGen SQL bugs

## License

GPL-2.0+

## Credits

- **Author:** dewolfe001
- **Website:** https://shawndewolfe.com
- **Built for:** Reliable NextGen Gallery integration

---

**Note:** This plugin requires NextGen Gallery to be installed, but it does NOT require NextGen Gallery to be working perfectly. It will access your gallery data directly even if NextGen's display types are broken.
