# Quick Start Guide - NGVF Standalone

## What You Need to Know

This is a **NEW, BETTER version** of the vertical filmstrip plugin that **bypasses NextGen Gallery's broken display type system**.

### Why Switch?

❌ Old version: `[ngg src="galleries" ids="1" display="vertical_filmstrip"]` - **Doesn't work** due to NextGen SQL bugs  
✅ New version: `[ngvf_gallery id="1"]` - **Works reliably** with direct database access

## Installation (3 Steps)

### Step 1: Upload & Activate

1. Go to **Plugins → Add New → Upload Plugin**
2. Choose `ngvf-standalone.zip`
3. Click **Install Now**
4. Click **Activate Plugin**

### Step 2: Find Your Gallery ID

1. Go to **Gallery → Manage Galleries**
2. Look at the first column to find your gallery ID
3. Note the number (e.g., "1", "5", "12")

### Step 3: Add Shortcode

Edit your page and replace the old shortcode with:

```
[ngvf_gallery id="1"]
```

Replace `1` with your actual gallery ID from Step 2.

**That's it!** Your gallery should now display perfectly.

## Your Specific Example

Based on your page at https://jac.projectsdc.com/gallery/expo-86/

**Old shortcode (broken):**
```
[ngg src="galleries" ids="1" display="vertical_filmstrip" thumbnail_columns="2" images_per_page="12"]
```

**New shortcode (working):**
```
[ngvf_gallery id="1" columns="2" per_page="12"]
```

## Common Options

### 2 Columns with 12 Images
```
[ngvf_gallery id="1" columns="2" per_page="12"]
```

### 3 Columns with 20 Images
```
[ngvf_gallery id="1" columns="3" per_page="20"]
```

### 4 Columns with Larger Thumbnails
```
[ngvf_gallery id="1" columns="4" thumb_width="200" thumb_height="200"]
```

### Disable Lightbox
```
[ngvf_gallery id="1" lightbox="false"]
```

### No Pagination (Show All)
```
[ngvf_gallery id="1" per_page="1000" pagination="false"]
```

## What If It Doesn't Work?

### Check #1: Gallery ID
- Go to **Gallery → Manage Galleries**
- Verify the ID number
- Make sure the gallery has images

### Check #2: NextGen Gallery Active
- Go to **Plugins**
- Make sure "NextGen Gallery" is activated
- The images must exist in NextGen

### Check #3: Clear Cache
- Clear WordPress cache (if using cache plugin)
- Clear browser cache (Ctrl+Shift+R)
- Clear CloudFlare/CDN cache (if applicable)

### Check #4: View Page Source
- Right-click on the page
- Select "View Page Source"
- Search for "ngvf-standalone-gallery"
- If you find it, the gallery is there but might have styling issues

## Differences from Old Plugin

| Old Plugin | New Plugin |
|------------|------------|
| Uses NextGen display types | Direct database access |
| Broken by SQL errors | Always works |
| Complex shortcode | Simple shortcode |
| `[ngg src=...]` | `[ngvf_gallery id=...]` |
| May not register | Always available |

## Can I Use Both?

**You can deactivate the old plugin** (`NextGen Vertical Filmstrip`) once you've switched to the new one. They don't conflict, but you only need the standalone version now.

## Getting Help

If you have issues:

1. Check the full **README.md** in the plugin folder
2. Enable WordPress debug:
   - Edit `wp-config.php`
   - Add: `define('WP_DEBUG', true);`
   - Check `/wp-content/debug.log` for errors
3. Contact: https://shawndewolfe.com

## Success Checklist

- [ ] Old plugin deactivated (optional)
- [ ] New standalone plugin uploaded
- [ ] New standalone plugin activated
- [ ] Gallery ID confirmed
- [ ] New shortcode added to page
- [ ] Page saved and viewed
- [ ] Cache cleared
- [ ] Gallery displays correctly!

---

**Version:** 2.0.0  
**Date:** October 28, 2025  
**Better, Faster, More Reliable!** 🚀
