# Changelog - NGVF Standalone

## [2.3.0] - 2025-10-28

### Added
- **Plugin Details Modal** - Click "View details" on plugins page to see comprehensive information
- Full feature documentation in modal popup
- Usage instructions with examples
- Parameter reference table
- Quick examples for common use cases
- Requirements and compatibility info
- Integrated donate call-to-action in details
- Professional styling with color-coded sections
- Links to support and documentation

### Enhanced
- Plugin page now shows complete information without leaving WordPress
- Better user onboarding experience
- Easy access to all plugin documentation
- Professional presentation matching WordPress standards

### Technical
- Uses WordPress Thickbox for modal display
- Custom CSS for professional styling
- JavaScript to intercept plugin details link
- Inline content rendering for fast display

## [2.2.0] - 2025-10-28

### Added
- **Settings Page** - New admin settings page under Settings → NGVF Gallery
- **Default Values Configuration** - Set default values for all galleries
  - Default number of columns
  - Default images per page
  - Default thumbnail dimensions
  - Default lightbox enable/disable
  - Default pagination enable/disable
- **Donate Link** - PayPal donation link on plugins page
- **Documentation Links** - Quick access to docs and support from plugins page
- **Settings Link** - Direct link to settings from plugins page
- **Usage Instructions** - Built-in help on settings page with examples
- **Shortcode Generator Help** - Clear examples in admin interface

### Enhanced
- Shortcode attributes now fall back to settings page defaults
- Better admin user experience with organized settings
- Professional plugin page presentation

### Technical
- Added WordPress Settings API integration
- Added options storage and retrieval
- Added admin menu page
- Added plugin action and row meta filters

## [2.1.0] - 2025-10-28

### Added
- **Full Lightbox Functionality** - Main image now opens in beautiful lightbox popup
- Image navigation arrows in lightbox (previous/next)
- Image counter display (e.g., "3 / 12")
- Close button with smooth animations
- Keyboard navigation in lightbox (arrow keys, ESC)
- Loading spinner while images load
- Smooth zoom animations
- Click outside to close lightbox
- Body scroll lock when lightbox is open
- Mobile-optimized lightbox controls

### Features
- Click main image to view full-size in lightbox
- Navigate between images using arrow buttons or keyboard
- ESC key to close lightbox
- Click outside image to close
- Image counter shows current position
- Responsive lightbox design for mobile
- Smooth transitions and animations
- Preloading for faster image display

### Technical
- New lightbox.css file for popup styling
- New lightbox.js file for popup functionality
- Integrated with existing thumbnail navigation
- Works seamlessly with gallery pagination
- No external dependencies

## [2.0.0] - 2025-10-28

### Changed
- Complete rewrite as standalone plugin
- Bypasses NextGen Gallery's broken display type system
- Direct database integration with NextGen Gallery
- New simpler shortcode: `[ngvf_gallery]`

### Added
- Direct NextGen Gallery database queries
- Fallback image URL construction
- Better error handling
- Standalone rendering system
- Independent of NextGen's internal bugs

### Fixed
- Issues with NextGen Gallery SQL errors
- Display type registration failures
- Complex shortcode requirements

## [1.0.x] - Deprecated

Original version that used NextGen's display type system. Deprecated due to NextGen Gallery SQL bugs preventing reliable operation.

---

## Version Comparison

| Version | Status | Key Feature |
|---------|--------|-------------|
| 2.1.0 | Current | Lightbox functionality added |
| 2.0.0 | Stable | Standalone with direct DB access |
| 1.0.x | Deprecated | Used NextGen display types |

---

## Upgrade Notes

### From 2.0.0 to 2.1.0
- Simply replace plugin files or update via WordPress
- No shortcode changes needed
- Lightbox works automatically
- Can disable with `lightbox="false"` if needed

### From 1.0.x to 2.1.0
- Must update shortcode syntax
- Old: `[ngg src="galleries" ids="1" display="vertical_filmstrip"]`
- New: `[ngvf_gallery id="1"]`
- See QUICKSTART.md for migration guide
